/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hurstfrost.hudson.sounds.HudsonSoundsNotifier;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HudsonSoundsNotifier
extends Notifier {
    private List<SoundEvent> soundEvents;

    @DataBoundConstructor
    public HudsonSoundsNotifier() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public HudsonSoundsDescriptor getDescriptor() {
        return (HudsonSoundsDescriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SoundEvent event = this.getSoundEventFor(build.getResult(), build.getPreviousBuild() != null ? ((AbstractBuild)build.getPreviousBuild()).getResult() : null);
        if (event != null) {
            try {
                this.getDescriptor().playSound(event.getSoundId());
            }
            catch (UnplayableSoundBiteException e) {
                listener.getLogger().println("Failed to play sound '" + event.getSoundId() + "' : " + e.toString());
            }
        }
        return true;
    }

    public List<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    public void setSoundEvents(List<SoundEvent> newSounds) {
        ArrayList<SoundEvent> validatedList = new ArrayList<SoundEvent>();
        for (SoundEvent sound : newSounds) {
            if (SoundEvent.access$000((SoundEvent)sound) == null || sound.getSoundId() == null || sound.getFromResults().isEmpty()) continue;
            validatedList.add(sound);
        }
        this.soundEvents = validatedList;
    }

    public SoundEvent getSoundEventFor(Result result, Result previousResult) {
        if (CollectionUtils.isEmpty((Collection)this.soundEvents)) {
            return null;
        }
        SoundEvent foundEvent = null;
        for (SoundEvent event : this.soundEvents) {
            if (!SoundEvent.access$000((SoundEvent)event).equals(result) || CollectionUtils.isEmpty((Collection)SoundEvent.access$100((SoundEvent)event)) || !SoundEvent.access$100((SoundEvent)event).contains(previousResult != null ? previousResult : Result.NOT_BUILT)) continue;
            foundEvent = event;
            if (this.getDescriptor().getSound(foundEvent.getSoundId()) == null) continue;
            break;
        }
        return foundEvent;
    }
}

