/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonSoundsNotifier
extends Notifier {
    private List<SoundEvent> soundEvents;

    @DataBoundConstructor
    public HudsonSoundsNotifier() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public HudsonSoundsDescriptor getDescriptor() {
        return (HudsonSoundsDescriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        SoundEvent event = this.getSoundEventFor(build.getResult(), build.getPreviousBuild() != null ? ((AbstractBuild)build.getPreviousBuild()).getResult() : null);
        if (event != null) {
            try {
                this.getDescriptor().playSound(event.getSoundId());
            }
            catch (UnplayableSoundBiteException e) {
                listener.getLogger().println("Failed to play sound '" + event.getSoundId() + "' : " + e.toString());
            }
        }
        return true;
    }

    public List<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    public void setSoundEvents(List<SoundEvent> newSounds) {
        ArrayList<SoundEvent> validatedList = new ArrayList<SoundEvent>();
        for (SoundEvent sound : newSounds) {
            if (sound.toResult == null || sound.getSoundId() == null || sound.getFromResults().isEmpty()) continue;
            validatedList.add(sound);
        }
        this.soundEvents = validatedList;
    }

    public SoundEvent getSoundEventFor(Result result, Result previousResult) {
        if (CollectionUtils.isEmpty(this.soundEvents)) {
            return null;
        }
        SoundEvent foundEvent = null;
        for (SoundEvent event : this.soundEvents) {
            if (!event.toResult.equals(result) || CollectionUtils.isEmpty((Collection)event.fromResults) || !event.fromResults.contains(previousResult != null ? previousResult : Result.NOT_BUILT)) continue;
            foundEvent = event;
            if (this.getDescriptor().getSound(foundEvent.getSoundId()) == null) continue;
            break;
        }
        return foundEvent;
    }

    public static class UnplayableSoundBiteException
    extends Exception {
        private final HudsonSoundsDescriptor.SoundBite soundBite;

        public HudsonSoundsDescriptor.SoundBite getSoundBite() {
            return this.soundBite;
        }

        public UnplayableSoundBiteException(HudsonSoundsDescriptor.SoundBite bite, Exception e) {
            super(e);
            this.soundBite = bite;
        }

        public UnplayableSoundBiteException(String message) {
            super(message);
            this.soundBite = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HudsonSoundsDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final String INTERNAL_ARCHIVE = HudsonSoundsNotifier.class.getResource("/sound-archive.zip").toString();
        private String soundArchive = INTERNAL_ARCHIVE;
        private transient TreeMap<String, SoundBite> sounds;
        private transient boolean needsReindex;

        public HudsonSoundsDescriptor() {
            this.load();
            this.needsReindex = true;
        }

        public List<SoundBite> getSounds() {
            this.checkIndex();
            return new ArrayList<SoundBite>(this.sounds.values());
        }

        private void checkIndex() {
            if (this.needsReindex) {
                this.needsReindex = false;
                this.sounds = HudsonSoundsDescriptor.rebuildSoundsIndex(this.soundArchive);
            }
        }

        public SoundBite getSound(String id) {
            this.checkIndex();
            if (this.sounds != null && id != null) {
                return this.sounds.get(id);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static TreeMap<String, SoundBite> rebuildSoundsIndex(String urlString) {
            TreeMap<String, SoundBite> index = new TreeMap<String, SoundBite>();
            try {
                URL url = new URL(urlString);
                URLConnection connection = url.openConnection();
                ZipInputStream zipInputStream = new ZipInputStream(connection.getInputStream());
                try {
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        String id = HudsonSoundsDescriptor.getBiteName(entry.getName());
                        AudioFileFormat f = null;
                        try {
                            f = AudioSystem.getAudioFileFormat(new BufferedInputStream(zipInputStream));
                        }
                        catch (UnsupportedAudioFileException e) {
                            // empty catch block
                        }
                        index.put(id, new SoundBite(id, entry.getName(), urlString, f));
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zipInputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index;
        }

        protected static String getBiteName(String name) {
            int dot;
            int slash = name.lastIndexOf(47);
            if (slash != -1) {
                name = name.substring(slash + 1);
            }
            if ((dot = name.lastIndexOf(46)) != -1) {
                name = name.substring(0, dot);
            }
            return name;
        }

        public String getSoundArchive() {
            return this.soundArchive;
        }

        public void setSoundArchive(String archive) {
            this.soundArchive = !StringUtils.isEmpty((String)archive) ? this.toUri(archive) : INTERNAL_ARCHIVE;
            this.needsReindex = true;
            this.sounds = null;
        }

        private String toUri(String archive) {
            if (archive.startsWith("http://") || archive.startsWith("file:/")) {
                return archive;
            }
            return new File(archive).toURI().toString();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.setSoundArchive(json.optString("soundArchive"));
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Hudson Sounds";
        }

        public HudsonSoundsNotifier newInstance(StaplerRequest req, JSONObject formData) {
            HudsonSoundsNotifier m = new HudsonSoundsNotifier();
            m.setSoundEvents(req.bindJSONToList(SoundEvent.class, formData.get("soundEvents")));
            return m;
        }

        public FormValidation doTestSound(@QueryParameter String selectedSound) {
            if (StringUtils.isEmpty((String)selectedSound)) {
                return FormValidation.error((String)"Please choose a sound to test.");
            }
            try {
                this.playSound(selectedSound);
            }
            catch (UnplayableSoundBiteException e) {
                return FormValidation.error((String)("Failed to make sound '" + selectedSound + "' : " + e.toString()));
            }
            return FormValidation.ok((String)("Hudson made sound '" + selectedSound + "' successfully."));
        }

        public FormValidation doCheckSoundArchive(@QueryParameter String value) {
            URI uri;
            try {
                uri = new URI(this.toUri(value));
            }
            catch (URISyntaxException e) {
                return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + e.toString() + ")"));
            }
            if (uri.getScheme().equals("file")) {
                if (new File(uri).exists()) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)("File not found '" + uri + "'"));
            }
            if (uri.getScheme().equals("http")) {
                try {
                    URLConnection openConnection = uri.toURL().openConnection();
                    if (openConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpUrlConnection = (HttpURLConnection)openConnection;
                        int responseCode = httpUrlConnection.getResponseCode();
                        if (responseCode == 200) {
                            return FormValidation.ok();
                        }
                        return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + httpUrlConnection.getResponseMessage() + ")"));
                    }
                    return FormValidation.warning((String)("The URL '" + value + "' is invalid"));
                }
                catch (IOException e) {
                    return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + e.toString() + ")"));
                }
            }
            return FormValidation.warning((String)("The URI '" + value + "' is invalid"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void playSound(String id) throws UnplayableSoundBiteException {
            SoundBite soundBite = this.getSound(id);
            if (soundBite != null) {
                try {
                    URL url = new URL(soundBite.url);
                    URLConnection connection = url.openConnection();
                    ZipInputStream zipInputStream = new ZipInputStream(connection.getInputStream());
                    try {
                        ZipEntry entry;
                        while ((entry = zipInputStream.getNextEntry()) != null) {
                            if (!entry.getName().equals(soundBite.entryName)) continue;
                            BufferedInputStream stream = new BufferedInputStream(zipInputStream);
                            this.playSoundBite(AudioSystem.getAudioInputStream(stream));
                            return;
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)zipInputStream);
                    }
                }
                catch (Exception e) {
                    throw new UnplayableSoundBiteException(soundBite, e);
                }
            }
            throw new UnplayableSoundBiteException("No such sound.");
        }

        protected void playSoundBite(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
            int read;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open();
            line.start();
            byte[] buffer = new byte[8096];
            while ((read = audioInputStream.read(buffer)) > 0) {
                line.write(buffer, 0, read);
            }
            line.drain();
            line.close();
        }

        public static class SoundBite {
            public final String id;
            public final String entryName;
            public final String url;
            public final AudioFileFormat format;

            public SoundBite(String _id, String _entryName, String _url, AudioFileFormat _format) {
                this.id = _id;
                this.entryName = _entryName;
                this.url = _url;
                this.format = _format;
            }

            public String getId() {
                return this.id;
            }

            public String getEntryName() {
                return this.entryName;
            }

            public String getUrl() {
                return this.url;
            }

            public AudioFileFormat getFormat() {
                return this.format;
            }

            public String getDescription() {
                if (this.format == null) {
                    return this.id + " (unsupported format)";
                }
                return this.id + " (" + this.format.getType() + ")";
            }

            public String toString() {
                return this.getDescription();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoundEvent {
        private final String soundId;
        private final Result toResult;
        private final Set<Result> fromResults;

        @DataBoundConstructor
        public SoundEvent(String soundId, String toResult, boolean fromNotBuilt, boolean fromAborted, boolean fromFailure, boolean fromUnstable, boolean fromSuccess) {
            Result result;
            this.soundId = soundId;
            Result result2 = result = toResult != null ? Result.fromString((String)toResult) : null;
            if (result != null && !result.toString().equals(toResult)) {
                result = null;
            }
            this.toResult = result;
            this.fromResults = new HashSet<Result>();
            this.setFromNotBuilt(fromNotBuilt);
            this.setFromAborted(fromAborted);
            this.setFromFailure(fromFailure);
            this.setFromUnstable(fromUnstable);
            this.setFromSuccess(fromSuccess);
        }

        public String getSoundId() {
            return this.soundId;
        }

        public Result getToBuildResult() {
            return this.toResult;
        }

        public boolean isFromNotBuilt() {
            return this.fromResults.contains(Result.NOT_BUILT);
        }

        public void setFromNotBuilt(boolean b) {
            if (b) {
                this.fromResults.add(Result.NOT_BUILT);
            } else {
                this.fromResults.remove(Result.NOT_BUILT);
            }
        }

        public boolean isFromAborted() {
            return this.fromResults.contains(Result.ABORTED);
        }

        public void setFromAborted(boolean b) {
            if (b) {
                this.fromResults.add(Result.ABORTED);
            } else {
                this.fromResults.remove(Result.ABORTED);
            }
        }

        public boolean isFromFailure() {
            return this.fromResults.contains(Result.FAILURE);
        }

        public void setFromFailure(boolean b) {
            if (b) {
                this.fromResults.add(Result.FAILURE);
            } else {
                this.fromResults.remove(Result.FAILURE);
            }
        }

        public boolean isFromUnstable() {
            return this.fromResults.contains(Result.UNSTABLE);
        }

        public void setFromUnstable(boolean b) {
            if (b) {
                this.fromResults.add(Result.UNSTABLE);
            } else {
                this.fromResults.remove(Result.UNSTABLE);
            }
        }

        public boolean isFromSuccess() {
            return this.fromResults.contains(Result.SUCCESS);
        }

        public void setFromSuccess(boolean b) {
            if (b) {
                this.fromResults.add(Result.SUCCESS);
            } else {
                this.fromResults.remove(Result.SUCCESS);
            }
        }

        public Set<Result> getFromResults() {
            return this.fromResults;
        }
    }
}

