/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Messages;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHLauncher
extends ComputerLauncher {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private transient Connection connection;
    private static final int BUFFER_SIZE = 2048;
    public static final Descriptor<ComputerLauncher> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String username, String password) {
        this.host = host;
        this.port = port == 0 ? 22 : port;
        this.username = username;
        this.password = password;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    private static String getWorkingDirectory(SlaveComputer computer) {
        String workingDirectory = computer.getNode().getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    public synchronized void launch(SlaveComputer computer, StreamTaskListener listener) {
        this.connection = new Connection(this.host, this.port);
        try {
            this.openConnection(listener);
            String java = this.findJava(listener);
            String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
            this.copySlaveJar(listener, workingDirectory);
            this.startSlave(computer, listener, java, workingDirectory);
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Connection closed.");
        }
    }

    private void startSlave(SlaveComputer computer, final StreamTaskListener listener, String java, String workingDirectory) throws IOException {
        final Session session = this.connection.openSession();
        try {
            session.execCommand("cd " + workingDirectory + " && " + java + " -jar slave.jar");
            final StreamGobbler out = new StreamGobbler(session.getStdout());
            final StreamGobbler err = new StreamGobbler(session.getStderr());
            new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), (InputStream)err, (OutputStream)listener.getLogger()).start();
            computer.setChannel((InputStream)out, session.getStdin(), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    if (cause != null) {
                        cause.printStackTrace(listener.error(Messages.Slave_Terminated((Object)SSHLauncher.getTimestamp())));
                    }
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error("closed"));
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error("closed"));
                    }
                    try {
                        err.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error("closed"));
                    }
                }
            });
        }
        catch (InterruptedException e) {
            session.close();
            e.printStackTrace(listener.error("aborted"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySlaveJar(StreamTaskListener listener, String workingDirectory) throws IOException {
        String fileName = workingDirectory + "/slave.jar";
        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Starting sftp client...");
        SFTPv3Client sftpClient = null;
        try {
            sftpClient = new SFTPv3Client(this.connection);
            try {
                SFTPv3FileAttributes fileAttributes;
                try {
                    fileAttributes = sftpClient.stat(workingDirectory);
                }
                catch (SFTPException e) {
                    fileAttributes = null;
                }
                if (fileAttributes == null) {
                    listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Remote file system root '" + workingDirectory + "' does not exist. Will try to create it");
                    sftpClient.mkdir(workingDirectory, 448);
                } else if (fileAttributes.isRegularFile()) {
                    throw new IOException("Remote file system root '" + workingDirectory + "' is a file not a directory or a symlink");
                }
                listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Copying latest slave.jar...");
                SFTPv3FileHandle fileHandle = sftpClient.createFile(fileName);
                InputStream is = null;
                try {
                    is = Hudson.getInstance().servletContext.getResourceAsStream("/WEB-INF/slave.jar");
                    byte[] buf = new byte[2048];
                    listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Sending data...");
                    int count = 0;
                    try {
                        int len;
                        while ((len = is.read(buf)) != -1) {
                            sftpClient.write(fileHandle, (long)count, buf, 0, len);
                            count += len;
                        }
                        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Sent " + count + " bytes.");
                    }
                    catch (Exception e) {
                        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Error writing to remote file");
                        throw new IOException2("Error writing to remote file", (Throwable)e);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Error creating file");
                e.printStackTrace(listener.getLogger());
                throw new IOException2("Could not copy slave.jar to slave", (Throwable)e);
            }
        }
        finally {
            if (sftpClient != null) {
                sftpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findJava(StreamTaskListener listener) throws IOException {
        String line;
        String java;
        block10: {
            java = "java";
            listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Checking default java version");
            line = null;
            Session session = this.connection.openSession();
            try {
                session.execCommand(java + " -version");
                StreamGobbler out = new StreamGobbler(session.getStdout());
                StreamGobbler err = new StreamGobbler(session.getStderr());
                try {
                    BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)out));
                    BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)err));
                    for (BufferedReader r : new BufferedReader[]{r1, r2}) {
                        while (null != (line = r.readLine())) {
                            if (!line.startsWith("java version \"")) continue;
                            break block10;
                        }
                    }
                }
                finally {
                    out.close();
                    err.close();
                }
            }
            finally {
                session.close();
            }
        }
        if (line == null || !line.startsWith("java version \"")) {
            throw new IOException("The default version of java is either unsupported version or unknown");
        }
        line = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] " + java + " version = " + line);
        if (line.compareTo("1.5") < 0) {
            throw new IOException("Could not find a version of java that is at least version 1.5");
        }
        return java;
    }

    private void openConnection(StreamTaskListener listener) throws IOException {
        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Opening SSH connection to " + this.host + ":" + this.port);
        this.connection.connect();
        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Authenticating as " + this.username + "/******");
        boolean isAuthenicated = this.connection.authenticateWithPassword(this.username, this.password);
        if (!isAuthenicated || !this.connection.isAuthenticationComplete()) {
            listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Authentication failed.");
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Connection closed.");
            throw new IOException("Authentication failed.");
        }
        listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Authentication successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, StreamTaskListener listener) {
        String workingDirectory = SSHLauncher.getWorkingDirectory(slaveComputer);
        String fileName = workingDirectory + "/slave.jar";
        if (this.connection != null) {
            SFTPv3Client sftpClient = null;
            try {
                sftpClient = new SFTPv3Client(this.connection);
                sftpClient.rm(fileName);
            }
            catch (Exception e) {
                listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Error deleting file");
                e.printStackTrace(listener.getLogger());
            }
            finally {
                if (sftpClient != null) {
                    sftpClient.close();
                }
            }
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(SSHLauncher.getTimestamp() + " [SSH] Connection closed.");
        }
        super.afterDisconnect(slaveComputer, listener);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        protected DescriptorImpl() {
            super(SSHLauncher.class);
        }

        public String getDisplayName() {
            return "Launch slave agents on Linux machines via SSH";
        }
    }
}

