/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SSHLauncher
extends ComputerLauncher {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String privatekey;
    private final String jvmOptions;
    private transient Connection connection;
    private static final int BUFFER_SIZE = 2048;
    public static final Descriptor<ComputerLauncher> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions) {
        this.host = host;
        this.jvmOptions = jvmOptions;
        this.port = port == 0 ? 22 : port;
        this.username = username;
        this.password = password;
        this.privatekey = privatekey;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    private static String getWorkingDirectory(SlaveComputer computer) {
        String workingDirectory = computer.getNode().getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    public synchronized void launch(SlaveComputer computer, StreamTaskListener listener) {
        this.connection = new Connection(this.host, this.port);
        try {
            this.openConnection(listener);
            this.reportEnvironment(listener);
            String java = null;
            ArrayList<String> tried = new ArrayList<String>();
            block6: for (JavaProvider provider : JavaProvider.all()) {
                for (String javaCommand : provider.getJavas(listener, this.connection)) {
                    try {
                        tried.add(javaCommand);
                        java = this.checkJavaVersion(listener, javaCommand);
                        if (java == null) continue;
                        break block6;
                    }
                    catch (IOException e) {
                    }
                }
            }
            if (java == null) {
                throw new IOException("Could not find any known supported java version in " + tried);
            }
            String workingDirectory = SSHLauncher.getWorkingDirectory((SlaveComputer)computer);
            this.copySlaveJar(listener, workingDirectory);
            this.startSlave(computer, listener, java, workingDirectory);
            PluginImpl.register((Connection)this.connection);
        }
        catch (RuntimeException e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (Error e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
        }
    }

    private void startSlave(SlaveComputer computer, StreamTaskListener listener, String java, String workingDirectory) throws IOException {
        Session session = this.connection.openSession();
        String cmd = "cd '" + workingDirectory + "' && " + java + (this.jvmOptions == null ? "" : " " + this.jvmOptions) + " -jar slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSlaveProcess((Object)SSHLauncher.getTimestamp(), (Object)cmd));
        session.execCommand(cmd);
        StreamGobbler out = new StreamGobbler(session.getStdout());
        StreamGobbler err = new StreamGobbler(session.getStderr());
        new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), (InputStream)err, (OutputStream)listener.getLogger()).start();
        try {
            computer.setChannel((InputStream)out, session.getStdin(), (OutputStream)listener.getLogger(), (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            session.close();
            throw new IOException2(Messages.SSHLauncher_AbortedDuringConnectionOpen(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySlaveJar(StreamTaskListener listener, String workingDirectory) throws IOException {
        String fileName = workingDirectory + "/slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient((Object)SSHLauncher.getTimestamp()));
        SFTPv3Client sftpClient = null;
        try {
            sftpClient = new SFTPv3Client(this.connection);
            try {
                SFTPv3FileAttributes fileAttributes;
                try {
                    fileAttributes = sftpClient.stat(workingDirectory);
                }
                catch (SFTPException e) {
                    fileAttributes = null;
                }
                if (fileAttributes == null) {
                    listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist((Object)SSHLauncher.getTimestamp(), (Object)workingDirectory));
                    sftpClient.mkdir(workingDirectory, 448);
                } else if (fileAttributes.isRegularFile()) {
                    throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile((Object)workingDirectory));
                }
                try {
                    sftpClient.rm(fileName);
                }
                catch (IOException e) {
                    // empty catch block
                }
                listener.getLogger().println(Messages.SSHLauncher_CopyingSlaveJar((Object)SSHLauncher.getTimestamp()));
                SFTPv3FileHandle fileHandle = sftpClient.createFile(fileName);
                InputStream is = null;
                try {
                    is = Hudson.getInstance().servletContext.getResourceAsStream("/WEB-INF/slave.jar");
                    byte[] buf = new byte[2048];
                    int count = 0;
                    try {
                        int len;
                        while ((len = is.read(buf)) != -1) {
                            sftpClient.write(fileHandle, (long)count, buf, 0, len);
                            count += len;
                        }
                        listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes((Object)SSHLauncher.getTimestamp(), (Object)count));
                    }
                    catch (Exception e) {
                        throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
            }
        }
        finally {
            if (sftpClient != null) {
                sftpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportEnvironment(StreamTaskListener listener) throws IOException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment((Object)SSHLauncher.getTimestamp()));
        Session session = this.connection.openSession();
        try {
            session.execCommand("set");
            StreamGobbler out = new StreamGobbler(session.getStdout());
            StreamGobbler err = new StreamGobbler(session.getStderr());
            try {
                BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)out));
                BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)err));
                for (BufferedReader r : new BufferedReader[]{r1, r2}) {
                    String line;
                    while (null != (line = r.readLine())) {
                        listener.getLogger().println(line);
                    }
                }
            }
            finally {
                out.close();
                err.close();
                listener.getLogger().println();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkJavaVersion(StreamTaskListener listener, String javaCommand) throws IOException {
        String line;
        block10: {
            listener.getLogger().println(Messages.SSHLauncher_CheckingDefaultJava((Object)SSHLauncher.getTimestamp()));
            line = null;
            Session session = this.connection.openSession();
            try {
                session.execCommand(javaCommand + " -version");
                StreamGobbler out = new StreamGobbler(session.getStdout());
                StreamGobbler err = new StreamGobbler(session.getStderr());
                try {
                    BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)out));
                    BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)err));
                    for (BufferedReader r : new BufferedReader[]{r1, r2}) {
                        while (null != (line = r.readLine())) {
                            if (!line.startsWith("java version \"")) continue;
                            break block10;
                        }
                    }
                }
                finally {
                    out.close();
                    err.close();
                }
            }
            finally {
                session.close();
            }
        }
        if (line == null || !line.startsWith("java version \"")) {
            throw new IOException("The default version of java is either unsupported version or unknown");
        }
        line = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
        listener.getLogger().println(Messages.SSHLauncher_JavaVersionResult((Object)SSHLauncher.getTimestamp(), (Object)javaCommand, (Object)line));
        if (line.compareTo("1.5") < 0) {
            throw new IOException(Messages.SSHLauncher_NoJavaFound());
        }
        return javaCommand;
    }

    private void openConnection(StreamTaskListener listener) throws IOException {
        File key;
        listener.getLogger().println(Messages.SSHLauncher_OpeningSSHConnection((Object)SSHLauncher.getTimestamp(), (Object)(this.host + ":" + this.port)));
        this.connection.connect();
        boolean isAuthenticated = false;
        if (this.privatekey != null && this.privatekey.length() > 0 && (key = new File(this.privatekey)).exists()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingPublicKey((Object)SSHLauncher.getTimestamp(), (Object)this.username, (Object)this.privatekey));
            isAuthenticated = this.connection.authenticateWithPublicKey(this.username, key, this.password);
        }
        if (!isAuthenticated) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingUserPass((Object)SSHLauncher.getTimestamp(), (Object)this.username, (Object)"******"));
            isAuthenticated = this.connection.authenticateWithPassword(this.username, this.password);
        }
        if (!isAuthenticated || !this.connection.isAuthenticationComplete()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticationFailed((Object)SSHLauncher.getTimestamp()));
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
            throw new IOException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        listener.getLogger().println(Messages.SSHLauncher_AuthenticationSuccessful((Object)SSHLauncher.getTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, StreamTaskListener listener) {
        String workingDirectory = SSHLauncher.getWorkingDirectory((SlaveComputer)slaveComputer);
        String fileName = workingDirectory + "/slave.jar";
        if (this.connection != null) {
            SFTPv3Client sftpClient = null;
            try {
                sftpClient = new SFTPv3Client(this.connection);
                sftpClient.rm(fileName);
            }
            catch (Exception e) {
                e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile((Object)SSHLauncher.getTimestamp())));
            }
            finally {
                if (sftpClient != null) {
                    sftpClient.close();
                }
            }
            this.connection.close();
            PluginImpl.unregister((Connection)this.connection);
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
        }
        super.afterDisconnect(slaveComputer, listener);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivatekey() {
        return this.privatekey;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ String access$000() {
        return SSHLauncher.getTimestamp();
    }
}

