// CHECKSTYLE:OFF

package hudson.plugins.sshslaves;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Could not copy slave.jar to slave
     * 
     */
    public static String SSHLauncher_ErrorCopyingSlaveJar() {
        return holder.format("SSHLauncher.ErrorCopyingSlaveJar");
    }

    /**
     * Could not copy slave.jar to slave
     * 
     */
    public static Localizable _SSHLauncher_ErrorCopyingSlaveJar() {
        return new Localizable(holder, "SSHLauncher.ErrorCopyingSlaveJar");
    }

    /**
     * {0} [SSH] Remote file system root {1} does not exist. Will try to create it...
     * 
     */
    public static String SSHLauncher_RemoteFSDoesNotExist(Object arg1, Object arg2) {
        return holder.format("SSHLauncher.RemoteFSDoesNotExist", arg1, arg2);
    }

    /**
     * {0} [SSH] Remote file system root {1} does not exist. Will try to create it...
     * 
     */
    public static Localizable _SSHLauncher_RemoteFSDoesNotExist(Object arg1, Object arg2) {
        return new Localizable(holder, "SSHLauncher.RemoteFSDoesNotExist", arg1, arg2);
    }

    /**
     * {0} [SSH] Copied {1} bytes.
     * 
     */
    public static String SSHLauncher_CopiedXXXBytes(Object arg1, Object arg2) {
        return holder.format("SSHLauncher.CopiedXXXBytes", arg1, arg2);
    }

    /**
     * {0} [SSH] Copied {1} bytes.
     * 
     */
    public static Localizable _SSHLauncher_CopiedXXXBytes(Object arg1, Object arg2) {
        return new Localizable(holder, "SSHLauncher.CopiedXXXBytes", arg1, arg2);
    }

    /**
     * Could not find a version of java that is at least version 1.5
     * 
     */
    public static String SSHLauncher_NoJavaFound() {
        return holder.format("SSHLauncher.NoJavaFound");
    }

    /**
     * Could not find a version of java that is at least version 1.5
     * 
     */
    public static Localizable _SSHLauncher_NoJavaFound() {
        return new Localizable(holder, "SSHLauncher.NoJavaFound");
    }

    /**
     * {0} [SSH] Authenticating as {1}/{2}.
     * 
     */
    public static String SSHLauncher_AuthenticatingUserPass(Object arg1, Object arg2, Object arg3) {
        return holder.format("SSHLauncher.AuthenticatingUserPass", arg1, arg2, arg3);
    }

    /**
     * {0} [SSH] Authenticating as {1}/{2}.
     * 
     */
    public static Localizable _SSHLauncher_AuthenticatingUserPass(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "SSHLauncher.AuthenticatingUserPass", arg1, arg2, arg3);
    }

    /**
     * {0} [SSH] Checking default java version...
     * 
     */
    public static String SSHLauncher_CheckingDefaultJava(Object arg1) {
        return holder.format("SSHLauncher.CheckingDefaultJava", arg1);
    }

    /**
     * {0} [SSH] Checking default java version...
     * 
     */
    public static Localizable _SSHLauncher_CheckingDefaultJava(Object arg1) {
        return new Localizable(holder, "SSHLauncher.CheckingDefaultJava", arg1);
    }

    /**
     * {0} [SSH] Authentication failed.
     * 
     */
    public static String SSHLauncher_AuthenticationFailed(Object arg1) {
        return holder.format("SSHLauncher.AuthenticationFailed", arg1);
    }

    /**
     * {0} [SSH] Authentication failed.
     * 
     */
    public static Localizable _SSHLauncher_AuthenticationFailed(Object arg1) {
        return new Localizable(holder, "SSHLauncher.AuthenticationFailed", arg1);
    }

    /**
     * Launch slave agents on Unix machines via SSH
     * 
     */
    public static String SSHLauncher_DescriptorDisplayName() {
        return holder.format("SSHLauncher.DescriptorDisplayName");
    }

    /**
     * Launch slave agents on Unix machines via SSH
     * 
     */
    public static Localizable _SSHLauncher_DescriptorDisplayName() {
        return new Localizable(holder, "SSHLauncher.DescriptorDisplayName");
    }

    /**
     * {0} [SSH] Authentication successful.
     * 
     */
    public static String SSHLauncher_AuthenticationSuccessful(Object arg1) {
        return holder.format("SSHLauncher.AuthenticationSuccessful", arg1);
    }

    /**
     * {0} [SSH] Authentication successful.
     * 
     */
    public static Localizable _SSHLauncher_AuthenticationSuccessful(Object arg1) {
        return new Localizable(holder, "SSHLauncher.AuthenticationSuccessful", arg1);
    }

    /**
     * {0} [SSH] Error deleting file.
     * 
     */
    public static String SSHLauncher_ErrorDeletingFile(Object arg1) {
        return holder.format("SSHLauncher.ErrorDeletingFile", arg1);
    }

    /**
     * {0} [SSH] Error deleting file.
     * 
     */
    public static Localizable _SSHLauncher_ErrorDeletingFile(Object arg1) {
        return new Localizable(holder, "SSHLauncher.ErrorDeletingFile", arg1);
    }

    /**
     * {0} [SSH] Connection closed.
     * 
     */
    public static String SSHLauncher_ConnectionClosed(Object arg1) {
        return holder.format("SSHLauncher.ConnectionClosed", arg1);
    }

    /**
     * {0} [SSH] Connection closed.
     * 
     */
    public static Localizable _SSHLauncher_ConnectionClosed(Object arg1) {
        return new Localizable(holder, "SSHLauncher.ConnectionClosed", arg1);
    }

    /**
     * {0} [SSH] {1} -version returned {2}.
     * 
     */
    public static String SSHLauncher_JavaVersionResult(Object arg1, Object arg2, Object arg3) {
        return holder.format("SSHLauncher.JavaVersionResult", arg1, arg2, arg3);
    }

    /**
     * {0} [SSH] {1} -version returned {2}.
     * 
     */
    public static Localizable _SSHLauncher_JavaVersionResult(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "SSHLauncher.JavaVersionResult", arg1, arg2, arg3);
    }

    /**
     * {0} [SSH] Authenticating as {1} with {2}.
     * 
     */
    public static String SSHLauncher_AuthenticatingPublicKey(Object arg1, Object arg2, Object arg3) {
        return holder.format("SSHLauncher.AuthenticatingPublicKey", arg1, arg2, arg3);
    }

    /**
     * {0} [SSH] Authenticating as {1} with {2}.
     * 
     */
    public static Localizable _SSHLauncher_AuthenticatingPublicKey(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "SSHLauncher.AuthenticatingPublicKey", arg1, arg2, arg3);
    }

    /**
     * Exception thrown while closing connection.
     * 
     */
    public static String SSHLauncher_ErrorWhileClosingConnection() {
        return holder.format("SSHLauncher.ErrorWhileClosingConnection");
    }

    /**
     * Exception thrown while closing connection.
     * 
     */
    public static Localizable _SSHLauncher_ErrorWhileClosingConnection() {
        return new Localizable(holder, "SSHLauncher.ErrorWhileClosingConnection");
    }

    /**
     * Authentication failed.
     * 
     */
    public static String SSHLauncher_AuthenticationFailedException() {
        return holder.format("SSHLauncher.AuthenticationFailedException");
    }

    /**
     * Authentication failed.
     * 
     */
    public static Localizable _SSHLauncher_AuthenticationFailedException() {
        return new Localizable(holder, "SSHLauncher.AuthenticationFailedException");
    }

    /**
     * Remote file system root {0} is a file not a directory or a symlink.
     * 
     */
    public static String SSHLauncher_RemoteFSIsAFile(Object arg1) {
        return holder.format("SSHLauncher.RemoteFSIsAFile", arg1);
    }

    /**
     * Remote file system root {0} is a file not a directory or a symlink.
     * 
     */
    public static Localizable _SSHLauncher_RemoteFSIsAFile(Object arg1) {
        return new Localizable(holder, "SSHLauncher.RemoteFSIsAFile", arg1);
    }

    /**
     * {0} [SSH] Copying latest slave.jar...
     * 
     */
    public static String SSHLauncher_CopyingSlaveJar(Object arg1) {
        return holder.format("SSHLauncher.CopyingSlaveJar", arg1);
    }

    /**
     * {0} [SSH] Copying latest slave.jar...
     * 
     */
    public static Localizable _SSHLauncher_CopyingSlaveJar(Object arg1) {
        return new Localizable(holder, "SSHLauncher.CopyingSlaveJar", arg1);
    }

    /**
     * Slave start aborted.
     * 
     */
    public static String SSHLauncher_AbortedDuringConnectionOpen() {
        return holder.format("SSHLauncher.AbortedDuringConnectionOpen");
    }

    /**
     * Slave start aborted.
     * 
     */
    public static Localizable _SSHLauncher_AbortedDuringConnectionOpen() {
        return new Localizable(holder, "SSHLauncher.AbortedDuringConnectionOpen");
    }

    /**
     * Unexpected error in launching a slave. This is probably a bug in Hudson.
     * 
     */
    public static String SSHLauncher_UnexpectedError() {
        return holder.format("SSHLauncher.UnexpectedError");
    }

    /**
     * Unexpected error in launching a slave. This is probably a bug in Hudson.
     * 
     */
    public static Localizable _SSHLauncher_UnexpectedError() {
        return new Localizable(holder, "SSHLauncher.UnexpectedError");
    }

    /**
     * {0} [SSH] Starting sftp client.
     * 
     */
    public static String SSHLauncher_StartingSFTPClient(Object arg1) {
        return holder.format("SSHLauncher.StartingSFTPClient", arg1);
    }

    /**
     * {0} [SSH] Starting sftp client.
     * 
     */
    public static Localizable _SSHLauncher_StartingSFTPClient(Object arg1) {
        return new Localizable(holder, "SSHLauncher.StartingSFTPClient", arg1);
    }

    /**
     * {0} [SSH] Opening SSH connection to {1}.
     * 
     */
    public static String SSHLauncher_OpeningSSHConnection(Object arg1, Object arg2) {
        return holder.format("SSHLauncher.OpeningSSHConnection", arg1, arg2);
    }

    /**
     * {0} [SSH] Opening SSH connection to {1}.
     * 
     */
    public static Localizable _SSHLauncher_OpeningSSHConnection(Object arg1, Object arg2) {
        return new Localizable(holder, "SSHLauncher.OpeningSSHConnection", arg1, arg2);
    }

}
