/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import hudson.AbortException;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.DataBoundConstructor;

public class SSHLauncher
extends ComputerLauncher {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String privatekey;
    private final String jvmOptions;
    private transient Connection connection;
    private static final int BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(SSHLauncher.class.getName());

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions) {
        this.host = host;
        this.jvmOptions = jvmOptions;
        this.port = port == 0 ? 22 : port;
        this.username = username;
        this.password = password;
        this.privatekey = privatekey;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    private static String getWorkingDirectory(SlaveComputer computer) {
        String workingDirectory = computer.getNode().getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    public synchronized void launch(SlaveComputer computer, TaskListener listener) {
        this.connection = new Connection(this.host, this.port);
        try {
            this.openConnection(listener);
            this.reportEnvironment(listener);
            String java = null;
            ArrayList<String> tried = new ArrayList<String>();
            block6: for (JavaProvider provider : JavaProvider.all()) {
                for (String javaCommand : provider.getJavas(listener, this.connection)) {
                    LOGGER.fine("Trying Java at " + javaCommand);
                    try {
                        tried.add(javaCommand);
                        java = this.checkJavaVersion(listener, javaCommand);
                        if (java == null) continue;
                        break block6;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Failed to check the Java version", e);
                    }
                }
            }
            if (java == null) {
                throw new IOException("Could not find any known supported java version in " + tried);
            }
            String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
            this.copySlaveJar(listener, workingDirectory);
            this.startSlave(computer, listener, java, workingDirectory);
            PluginImpl.register(this.connection);
        }
        catch (RuntimeException e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (Error e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(SSHLauncher.getTimestamp()));
        }
    }

    private void startSlave(SlaveComputer computer, final TaskListener listener, String java, String workingDirectory) throws IOException {
        final Session session = this.connection.openSession();
        String cmd = "cd '" + workingDirectory + "' && " + java + (this.jvmOptions == null ? "" : " " + this.jvmOptions) + " -jar slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSlaveProcess(SSHLauncher.getTimestamp(), cmd));
        session.execCommand(cmd);
        final StreamGobbler out = new StreamGobbler(session.getStdout());
        final StreamGobbler err = new StreamGobbler(session.getStderr());
        new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), (InputStream)err, (OutputStream)listener.getLogger()).start();
        try {
            computer.setChannel((InputStream)out, session.getStdin(), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    if (cause != null) {
                        cause.printStackTrace(listener.error(hudson.model.Messages.Slave_Terminated((Object)SSHLauncher.getTimestamp())));
                    }
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                    }
                    try {
                        err.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                    }
                }
            });
        }
        catch (InterruptedException e) {
            session.close();
            throw new IOException2(Messages.SSHLauncher_AbortedDuringConnectionOpen(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySlaveJar(TaskListener listener, String workingDirectory) throws IOException {
        String fileName = workingDirectory + "/slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient(SSHLauncher.getTimestamp()));
        SFTPv3Client sftpClient = null;
        try {
            sftpClient = new SFTPv3Client(this.connection);
            try {
                SFTPv3FileAttributes fileAttributes;
                try {
                    fileAttributes = sftpClient.stat(workingDirectory);
                }
                catch (SFTPException e) {
                    fileAttributes = null;
                }
                if (fileAttributes == null) {
                    listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(SSHLauncher.getTimestamp(), workingDirectory));
                    sftpClient.mkdir(workingDirectory, 448);
                } else if (fileAttributes.isRegularFile()) {
                    throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile(workingDirectory));
                }
                try {
                    sftpClient.rm(fileName);
                }
                catch (IOException e) {
                    // empty catch block
                }
                listener.getLogger().println(Messages.SSHLauncher_CopyingSlaveJar(SSHLauncher.getTimestamp()));
                SFTPv3FileHandle fileHandle = sftpClient.createFile(fileName);
                InputStream is = null;
                try {
                    is = Hudson.getInstance().servletContext.getResourceAsStream("/WEB-INF/slave.jar");
                    byte[] buf = new byte[2048];
                    int count = 0;
                    try {
                        int len;
                        while ((len = is.read(buf)) != -1) {
                            sftpClient.write(fileHandle, (long)count, buf, 0, len);
                            count += len;
                        }
                        listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes(SSHLauncher.getTimestamp(), count));
                    }
                    catch (Exception e) {
                        throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
            }
        }
        finally {
            if (sftpClient != null) {
                sftpClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportEnvironment(TaskListener listener) throws IOException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment(SSHLauncher.getTimestamp()));
        Session session = this.connection.openSession();
        try {
            session.execCommand("set");
            StreamGobbler out = new StreamGobbler(session.getStdout());
            StreamGobbler err = new StreamGobbler(session.getStderr());
            try {
                BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)out));
                BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)err));
                for (BufferedReader r : new BufferedReader[]{r1, r2}) {
                    String line;
                    while (null != (line = r.readLine())) {
                        listener.getLogger().println(line);
                    }
                }
            }
            finally {
                out.close();
                err.close();
                listener.getLogger().println();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkJavaVersion(TaskListener listener, String javaCommand) throws IOException {
        StringWriter output;
        String line;
        block10: {
            listener.getLogger().println(Messages.SSHLauncher_CheckingDefaultJava(SSHLauncher.getTimestamp(), javaCommand));
            line = null;
            Session session = this.connection.openSession();
            output = new StringWriter();
            try {
                session.execCommand(javaCommand + " -version");
                StreamGobbler out = new StreamGobbler(session.getStdout());
                StreamGobbler err = new StreamGobbler(session.getStderr());
                try {
                    BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)out));
                    BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)err));
                    for (BufferedReader r : new BufferedReader[]{r1, r2}) {
                        while (null != (line = r.readLine())) {
                            output.write(line);
                            output.write("\n");
                            if (!line.startsWith("java version \"")) continue;
                            break block10;
                        }
                    }
                }
                finally {
                    out.close();
                    err.close();
                }
            }
            finally {
                session.close();
            }
        }
        if (line == null || !line.startsWith("java version \"")) {
            listener.getLogger().println(Messages.SSHLauncher_UknownJavaVersion(javaCommand));
            listener.getLogger().println(output);
            throw new IOException(Messages.SSHLauncher_UknownJavaVersion(javaCommand));
        }
        line = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
        listener.getLogger().println(Messages.SSHLauncher_JavaVersionResult(SSHLauncher.getTimestamp(), javaCommand, line));
        if (line.compareTo("1.5") < 0) {
            throw new IOException(Messages.SSHLauncher_NoJavaFound(line));
        }
        return javaCommand;
    }

    private void openConnection(TaskListener listener) throws IOException {
        File key;
        listener.getLogger().println(Messages.SSHLauncher_OpeningSSHConnection(SSHLauncher.getTimestamp(), this.host + ":" + this.port));
        this.connection.connect();
        String username = this.username;
        if (Util.fixEmpty((String)username) == null) {
            username = System.getProperty("user.name");
            LOGGER.fine("Defaulting the user name to " + username);
        }
        boolean isAuthenticated = false;
        if (Util.fixEmpty((String)this.privatekey) == null && Util.fixEmpty((String)this.password) == null) {
            File home = new File(System.getProperty("user.home"));
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File key2 = new File(home, ".ssh/" + keyName);
                if (key2.exists()) {
                    listener.getLogger().println(Messages.SSHLauncher_AuthenticatingPublicKey(SSHLauncher.getTimestamp(), username, key2));
                    isAuthenticated = this.connection.authenticateWithPublicKey(username, key2, null);
                }
                if (!isAuthenticated) continue;
                break;
            }
        }
        if (!isAuthenticated && Util.fixEmpty((String)this.privatekey) != null && (key = new File(this.privatekey)).exists()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingPublicKey(SSHLauncher.getTimestamp(), username, this.privatekey));
            if (PuTTYKey.isPuTTYKeyFile((File)key)) {
                LOGGER.fine(key + " is a PuTTY key file");
                String openSshKey = new PuTTYKey(key, this.password).toOpenSSH();
                isAuthenticated = this.connection.authenticateWithPublicKey(username, openSshKey.toCharArray(), this.password);
            } else {
                isAuthenticated = this.connection.authenticateWithPublicKey(username, key, this.password);
            }
        }
        if (!isAuthenticated) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingUserPass(SSHLauncher.getTimestamp(), username, "******"));
            isAuthenticated = this.connection.authenticateWithPassword(username, this.password);
        }
        if (!isAuthenticated || !this.connection.isAuthenticationComplete()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticationFailed(SSHLauncher.getTimestamp()));
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(SSHLauncher.getTimestamp()));
            throw new AbortException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        listener.getLogger().println(Messages.SSHLauncher_AuthenticationSuccessful(SSHLauncher.getTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, StreamTaskListener listener) {
        String workingDirectory = SSHLauncher.getWorkingDirectory(slaveComputer);
        String fileName = workingDirectory + "/slave.jar";
        if (this.connection != null) {
            SFTPv3Client sftpClient = null;
            try {
                sftpClient = new SFTPv3Client(this.connection);
                sftpClient.rm(fileName);
            }
            catch (Exception e) {
                e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.getTimestamp())));
            }
            finally {
                if (sftpClient != null) {
                    sftpClient.close();
                }
            }
            this.connection.close();
            PluginImpl.unregister(this.connection);
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(SSHLauncher.getTimestamp()));
        }
        super.afterDisconnect(slaveComputer, listener);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivatekey() {
        return this.privatekey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultJavaProvider
    extends JavaProvider {
        @Override
        public List<String> getJavas(TaskListener listener, Connection connection) {
            return Arrays.asList("java", "/usr/bin/java", "/usr/java/default/bin/java", "/usr/java/latest/bin/java", "/usr/local/bin/java", "/usr/local/java/bin/java");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }
    }
}

