/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.util.StreamCopyThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteLauncher
extends Launcher {
    private final Connection connection;

    public RemoteLauncher(TaskListener listener, Connection connection) {
        super(listener, null);
        this.connection = connection;
    }

    public Proc launch(Launcher.ProcStarter ps) throws IOException {
        this.maskedPrintCommandLine(ps.cmds(), ps.masks(), ps.pwd());
        String name = ps.cmds().toString();
        Session session = this.connection.openSession();
        session.execCommand(this.makeCommandLine(ps.cmds(), ps.pwd()));
        StreamCopyThread t1 = new StreamCopyThread("stdout copier: " + name, session.getStdout(), ps.stdout(), false);
        t1.start();
        StreamCopyThread t2 = new StreamCopyThread("stderr copier: " + name, session.getStderr(), (OutputStream)Functions.defaulted((Object)ps.stderr(), (Object)ps.stdout()), false);
        t2.start();
        StreamCopyThread t3 = new StreamCopyThread("stdin copier: " + name, ps.stdin(), session.getStdin(), true);
        t3.start();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Channel launchChannel(String[] cmd, OutputStream out, FilePath _workDir, Map<String, String> envVars) throws IOException, InterruptedException {
        this.printCommandLine(cmd, _workDir);
        Session session = this.connection.openSession();
        session.execCommand(this.makeCommandLine(Arrays.asList(cmd), _workDir));
        return new Channel("channel over ssh on " + this.connection.getHostname() + ":" + this.connection.getPort(), Computer.threadPoolForRemoting, session.getStdout(), (OutputStream)new BufferedOutputStream(session.getStdin()));
    }

    private String makeCommandLine(List<String> cmd, FilePath _workDir) {
        String workDir = _workDir == null ? null : _workDir.getRemote();
        return "cd '" + workDir + "' && " + Util.join(cmd, (String)" ");
    }

    public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
    }
}

