/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import hudson.AbortException;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.plugins.sshslaves.RemoteLauncher;
import hudson.plugins.sshslaves.SFTPClient;
import hudson.plugins.sshslaves.SFTPFileSystem;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.tools.JDKInstaller;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import hudson.util.StreamTaskListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class SSHLauncher
extends ComputerLauncher {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String privatekey;
    private final String jvmOptions;
    private transient Connection connection;
    private static final Logger LOGGER = Logger.getLogger(SSHLauncher.class.getName());

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions) {
        this.host = host;
        this.jvmOptions = jvmOptions;
        this.port = port == 0 ? 22 : port;
        this.username = username;
        this.password = password;
        this.privatekey = privatekey;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    private static String getWorkingDirectory(SlaveComputer computer) {
        String workingDirectory = computer.getNode().getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    public synchronized void launch(SlaveComputer computer, TaskListener listener) throws InterruptedException {
        this.connection = new Connection(this.host, this.port);
        try {
            this.openConnection(listener);
            this.verifyNoHeaderJunk(listener);
            this.reportEnvironment(listener);
            String java = null;
            ArrayList<String> tried = new ArrayList<String>();
            block8: for (JavaProvider provider : JavaProvider.all()) {
                for (String javaCommand : provider.getJavas(computer, listener, this.connection)) {
                    LOGGER.fine("Trying Java at " + javaCommand);
                    try {
                        tried.add(javaCommand);
                        java = this.checkJavaVersion(listener, javaCommand);
                        if (java == null) continue;
                        break block8;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Failed to check the Java version", e);
                    }
                }
            }
            String workingDirectory = SSHLauncher.getWorkingDirectory((SlaveComputer)computer);
            if (java == null) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                try {
                    java = this.attemptToInstallJDK(listener, workingDirectory, buf);
                }
                catch (IOException e) {
                    throw new IOException2("Could not find any known supported java version in " + tried + ", and we also failed to install JDK as a fallback", (Throwable)e);
                }
            }
            this.copySlaveJar(listener, workingDirectory);
            this.startSlave(computer, listener, java, workingDirectory);
            PluginImpl.register((Connection)this.connection);
        }
        catch (RuntimeException e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (Error e) {
            e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.getLogger());
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
        }
    }

    private void verifyNoHeaderJunk(TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.connection.exec("true", (OutputStream)baos);
        String s = baos.toString();
        if (s.length() != 0) {
            listener.getLogger().println(Messages.SSHLauncher_SSHHeeaderJunkDetected());
            listener.getLogger().println(s);
            throw new AbortException();
        }
    }

    private String attemptToInstallJDK(TaskListener listener, String workingDirectory, ByteArrayOutputStream buf) throws IOException, InterruptedException {
        if (this.connection.exec("uname -a", (OutputStream)new TeeOutputStream((OutputStream)buf, (OutputStream)listener.getLogger())) != 0) {
            throw new IOException("Failed to run 'uname' to obtain the environment");
        }
        String uname = buf.toString();
        JDKInstaller.Platform p = null;
        JDKInstaller.CPU cpu = null;
        if (uname.contains("GNU/Linux")) {
            p = JDKInstaller.Platform.LINUX;
        }
        if (uname.contains("SunOS")) {
            p = JDKInstaller.Platform.SOLARIS;
        }
        if (uname.contains("CYGWIN")) {
            p = JDKInstaller.Platform.WINDOWS;
        }
        if (uname.contains("Windows_NT")) {
            p = JDKInstaller.Platform.WINDOWS;
        }
        if (uname.contains("sparc")) {
            cpu = JDKInstaller.CPU.Sparc;
        }
        if (uname.contains("x86_64")) {
            cpu = JDKInstaller.CPU.amd64;
        }
        if (Pattern.compile("\\bi?[3-6]86\\b").matcher(uname).find()) {
            cpu = JDKInstaller.CPU.i386;
        }
        if (p == null || cpu == null) {
            throw new IOException(Messages.SSHLauncher_FailedToDetectEnvironment((Object)uname));
        }
        String javaDir = workingDirectory + "/jdk";
        String bundleFile = workingDirectory + "/" + p.bundleFileName;
        SFTPClient sftp = new SFTPClient(this.connection);
        this.connection.exec("rm -rf " + javaDir, (OutputStream)listener.getLogger());
        sftp.mkdirs(javaDir, 493);
        JDKInstaller jdk = new JDKInstaller("jdk-6u16-oth-JPR@CDS-CDS_Developer", true);
        URL bundle = jdk.locate(listener, p, cpu);
        listener.getLogger().println("Downloading JDK6u16");
        Util.copyStreamAndClose((InputStream)bundle.openStream(), (OutputStream)new BufferedOutputStream(sftp.writeToFile(bundleFile), 32768));
        sftp.chmod(bundleFile, 493);
        jdk.install((Launcher)new RemoteLauncher(listener, this.connection), p, (JDKInstaller.FileSystem)new SFTPFileSystem(sftp), listener, javaDir, bundleFile);
        return javaDir + "/bin/java";
    }

    private void startSlave(SlaveComputer computer, TaskListener listener, String java, String workingDirectory) throws IOException {
        Session session = this.connection.openSession();
        String cmd = "cd '" + workingDirectory + "' && " + java + (this.jvmOptions == null ? "" : " " + this.jvmOptions) + " -jar slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSlaveProcess((Object)SSHLauncher.getTimestamp(), (Object)cmd));
        session.execCommand(cmd);
        StreamGobbler out = new StreamGobbler(session.getStdout());
        StreamGobbler err = new StreamGobbler(session.getStderr());
        new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), (InputStream)err, (OutputStream)listener.getLogger()).start();
        try {
            computer.setChannel((InputStream)out, session.getStdin(), (OutputStream)listener.getLogger(), (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            session.close();
            throw new IOException2(Messages.SSHLauncher_AbortedDuringConnectionOpen(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySlaveJar(TaskListener listener, String workingDirectory) throws IOException {
        String fileName = workingDirectory + "/slave.jar";
        listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient((Object)SSHLauncher.getTimestamp()));
        SFTPClient sftpClient = null;
        try {
            sftpClient = new SFTPClient(this.connection);
            try {
                SFTPv3FileAttributes fileAttributes = sftpClient._stat(workingDirectory);
                if (fileAttributes == null) {
                    listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist((Object)SSHLauncher.getTimestamp(), (Object)workingDirectory));
                    sftpClient.mkdirs(workingDirectory, 448);
                } else if (fileAttributes.isRegularFile()) {
                    throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile((Object)workingDirectory));
                }
                try {
                    sftpClient.rm(fileName);
                }
                catch (IOException e) {
                    // empty catch block
                }
                listener.getLogger().println(Messages.SSHLauncher_CopyingSlaveJar((Object)SSHLauncher.getTimestamp()));
                try {
                    CountingOutputStream os = new CountingOutputStream(sftpClient.writeToFile(fileName));
                    Util.copyStreamAndClose((InputStream)Hudson.getInstance().servletContext.getResourceAsStream("/WEB-INF/slave.jar"), (OutputStream)os);
                    listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes((Object)SSHLauncher.getTimestamp(), (Object)os.getByteCount()));
                }
                catch (Exception e) {
                    throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new IOException2(Messages.SSHLauncher_ErrorCopyingSlaveJar(), (Throwable)e);
            }
        }
        finally {
            if (sftpClient != null) {
                sftpClient.close();
            }
        }
    }

    private void reportEnvironment(TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment((Object)SSHLauncher.getTimestamp()));
        this.connection.exec("set", (OutputStream)listener.getLogger());
    }

    private String checkJavaVersion(TaskListener listener, String javaCommand) throws IOException, InterruptedException {
        String line;
        listener.getLogger().println(Messages.SSHLauncher_CheckingDefaultJava((Object)SSHLauncher.getTimestamp(), (Object)javaCommand));
        StringWriter output = new StringWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.connection.exec(javaCommand + " " + this.jvmOptions + " -version", (OutputStream)out);
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        while (null != (line = r.readLine())) {
            output.write(line);
            output.write("\n");
            if (!(line = line.toLowerCase()).startsWith("java version \"") && !line.startsWith("openjdk version \"")) continue;
            line = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            listener.getLogger().println(Messages.SSHLauncher_JavaVersionResult((Object)SSHLauncher.getTimestamp(), (Object)javaCommand, (Object)line));
            if (line.compareTo("1.5") < 0) {
                throw new IOException(Messages.SSHLauncher_NoJavaFound((Object)line));
            }
            return javaCommand;
        }
        listener.getLogger().println(Messages.SSHLauncher_UknownJavaVersion((Object)javaCommand));
        listener.getLogger().println(output);
        throw new IOException(Messages.SSHLauncher_UknownJavaVersion((Object)javaCommand));
    }

    private void openConnection(TaskListener listener) throws IOException {
        File key;
        listener.getLogger().println(Messages.SSHLauncher_OpeningSSHConnection((Object)SSHLauncher.getTimestamp(), (Object)(this.host + ":" + this.port)));
        this.connection.connect();
        String username = this.username;
        if (Util.fixEmpty((String)username) == null) {
            username = System.getProperty("user.name");
            LOGGER.fine("Defaulting the user name to " + username);
        }
        boolean isAuthenticated = false;
        if (Util.fixEmpty((String)this.privatekey) == null && Util.fixEmpty((String)this.password) == null) {
            File home = new File(System.getProperty("user.home"));
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File key2 = new File(home, ".ssh/" + keyName);
                if (key2.exists()) {
                    listener.getLogger().println(Messages.SSHLauncher_AuthenticatingPublicKey((Object)SSHLauncher.getTimestamp(), (Object)username, (Object)key2));
                    isAuthenticated = this.connection.authenticateWithPublicKey(username, key2, null);
                }
                if (!isAuthenticated) continue;
                break;
            }
        }
        if (!isAuthenticated && Util.fixEmpty((String)this.privatekey) != null && (key = new File(this.privatekey)).exists()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingPublicKey((Object)SSHLauncher.getTimestamp(), (Object)username, (Object)this.privatekey));
            if (PuTTYKey.isPuTTYKeyFile((File)key)) {
                LOGGER.fine(key + " is a PuTTY key file");
                String openSshKey = new PuTTYKey(key, this.password).toOpenSSH();
                isAuthenticated = this.connection.authenticateWithPublicKey(username, openSshKey.toCharArray(), this.password);
            } else {
                isAuthenticated = this.connection.authenticateWithPublicKey(username, key, this.password);
            }
        }
        if (!isAuthenticated) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticatingUserPass((Object)SSHLauncher.getTimestamp(), (Object)username, (Object)"******"));
            isAuthenticated = this.connection.authenticateWithPassword(username, this.password);
        }
        if (!isAuthenticated || !this.connection.isAuthenticationComplete()) {
            listener.getLogger().println(Messages.SSHLauncher_AuthenticationFailed((Object)SSHLauncher.getTimestamp()));
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
            throw new AbortException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        listener.getLogger().println(Messages.SSHLauncher_AuthenticationSuccessful((Object)SSHLauncher.getTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, StreamTaskListener listener) {
        String workingDirectory = SSHLauncher.getWorkingDirectory((SlaveComputer)slaveComputer);
        String fileName = workingDirectory + "/slave.jar";
        if (this.connection != null) {
            SFTPv3Client sftpClient = null;
            try {
                sftpClient = new SFTPv3Client(this.connection);
                sftpClient.rm(fileName);
            }
            catch (Exception e) {
                e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile((Object)SSHLauncher.getTimestamp())));
            }
            finally {
                if (sftpClient != null) {
                    sftpClient.close();
                }
            }
            this.connection.close();
            PluginImpl.unregister((Connection)this.connection);
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed((Object)SSHLauncher.getTimestamp()));
        }
        super.afterDisconnect(slaveComputer, listener);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivatekey() {
        return this.privatekey;
    }

    static /* synthetic */ String access$000() {
        return SSHLauncher.getTimestamp();
    }

    static /* synthetic */ String access$100(SlaveComputer x0) {
        return SSHLauncher.getWorkingDirectory((SlaveComputer)x0);
    }
}

