/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.SFTPv3DirectoryEntry;
import hudson.plugins.sshslaves.SFTPClient;
import hudson.tools.JDKInstaller;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SFTPFileSystem
implements JDKInstaller.FileSystem {
    private static final int BUFFER_SIZE = 32768;
    private final SFTPClient sftp;

    public SFTPFileSystem(SFTPClient sftp) {
        this.sftp = sftp;
    }

    public void delete(String file) throws IOException, InterruptedException {
        this.sftp.rm(file);
    }

    public void chmod(String file, int mode) throws IOException, InterruptedException {
        this.sftp.chmod(file, mode);
    }

    public InputStream read(String file) throws IOException {
        return new BufferedInputStream(this.sftp.read(file), 32768);
    }

    public List<String> listSubDirectories(String dir) throws IOException, InterruptedException {
        ArrayList<String> r = new ArrayList<String>();
        for (SFTPv3DirectoryEntry e : this.sftp.ls(dir)) {
            r.add(e.filename);
        }
        return r;
    }

    public void pullUp(String from, String to) throws IOException, InterruptedException {
        for (SFTPv3DirectoryEntry e : this.sftp.ls(from)) {
            if (e.filename.equals(".") || e.filename.equals("..")) continue;
            this.sftp.mv(from + '/' + e.filename, to + '/' + e.filename);
        }
        this.sftp.rmdir(from);
    }
}

