/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.util.Secret;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SSHConnector
extends ComputerConnector {
    public final int port;
    public final String username;
    public final Secret password;
    public final String privatekey;
    public final String javaPath;
    public final String jvmOptions;

    @DataBoundConstructor
    public SSHConnector(int port, String username, String password, String privatekey, String jvmOptions, String javaPath) {
        this.jvmOptions = jvmOptions;
        this.port = port == 0 ? 22 : port;
        this.username = username;
        this.password = Secret.fromString((String)Util.fixEmpty((String)password));
        this.privatekey = privatekey;
        this.javaPath = javaPath;
    }

    public SSHLauncher launch(String host, TaskListener listener) throws IOException, InterruptedException {
        return new SSHLauncher(host, this.port, this.username, Secret.toString((Secret)this.password), this.privatekey, this.jvmOptions, this.javaPath);
    }

    @Extension
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }
    }
}

