/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.SSHBuildWrapper;
import org.jvnet.hudson.plugins.SSHSite;
import org.kohsuke.stapler.DataBoundConstructor;

public final class SSHBuildWrapper
extends BuildWrapper {
    public static final Logger LOGGER = Logger.getLogger(SSHBuildWrapper.class.getName());
    private String siteName;
    private String preScript;
    private String postScript;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SSHBuildWrapper() {
    }

    @DataBoundConstructor
    public SSHBuildWrapper(String siteName, String preScript, String postScript) {
        SSHSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
        this.preScript = preScript;
        this.postScript = postScript;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        1 env = new /* Unavailable Anonymous Inner Class!! */;
        this.executePreBuildScript(listener.getLogger());
        return env;
    }

    private void executePreBuildScript(PrintStream logger) {
        this.log(logger, "executing pre build script:\n" + this.preScript);
        SSHSite site = this.getSite();
        if (this.preScript != null && this.preScript.trim() != "") {
            site.executeCommand(logger, this.preScript);
        }
    }

    private void executePostBuildScript(PrintStream logger) {
        this.log(logger, "executing post build script:\n" + this.postScript);
        SSHSite site = this.getSite();
        if (this.postScript != null && this.postScript.trim() != "") {
            site.executeCommand(logger, this.postScript);
        }
    }

    public String getPreScript() {
        return this.preScript;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
    }

    public SSHSite getSite() {
        SSHSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SSHSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    private void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }

    static /* synthetic */ void access$000(SSHBuildWrapper x0, PrintStream x1) {
        x0.executePostBuildScript(x1);
    }
}

