/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import com.jcraft.jsch.JSchException;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.SSHSite;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class SSHBuildWrapper
extends BuildWrapper {
    public static final Logger LOGGER = Logger.getLogger(SSHBuildWrapper.class.getName());
    private String siteName;
    private String preScript;
    private String postScript;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SSHBuildWrapper() {
    }

    @DataBoundConstructor
    public SSHBuildWrapper(String siteName, String preScript, String postScript) {
        SSHSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
        this.preScript = preScript;
        this.postScript = postScript;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        BuildWrapper.Environment env = new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                SSHBuildWrapper.this.executePostBuildScript(listener.getLogger());
                return super.tearDown(build, listener);
            }
        };
        this.executePreBuildScript(listener.getLogger());
        return env;
    }

    private void executePreBuildScript(PrintStream logger) {
        this.log(logger, "executing pre build script:\n" + this.preScript);
        SSHSite site = this.getSite();
        if (this.preScript != null && this.preScript.trim() != "") {
            site.executeCommand(logger, this.preScript);
        }
    }

    private void executePostBuildScript(PrintStream logger) {
        this.log(logger, "executing post build script:\n" + this.postScript);
        SSHSite site = this.getSite();
        if (this.postScript != null && this.postScript.trim() != "") {
            site.executeCommand(logger, this.postScript);
        }
    }

    public String getPreScript() {
        return this.preScript;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
    }

    public SSHSite getSite() {
        SSHSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SSHSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    private void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private final CopyOnWriteList<SSHSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(SSHBuildWrapper.class);
            this.load();
        }

        protected DescriptorImpl(Class<? extends BuildWrapper> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Execute shell script on remote host using ssh";
        }

        public String getShortName() {
            return "[SSH] ";
        }

        public String getHelpFile() {
            return "/plugin/ssh/help.html";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) {
            SSHBuildWrapper pub = new SSHBuildWrapper();
            req.bindParameters((Object)pub, "ssh.");
            return pub;
        }

        public SSHSite[] getSites() {
            Iterator it = this.sites.iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return (SSHSite[])this.sites.toArray((Object[])new SSHSite[size]);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindParametersToList(SSHSite.class, "ssh."));
            this.save();
            return true;
        }

        public FormValidation doKeyfileCheck(@QueryParameter String keyfile) {
            File f;
            if ((keyfile = Util.fixEmpty((String)keyfile)) != null && !(f = new File(keyfile)).isFile()) {
                return FormValidation.error((String)"keyfile does not exist");
            }
            return FormValidation.ok();
        }

        public FormValidation doLoginCheck(StaplerRequest request) {
            String hostname = Util.fixEmpty((String)request.getParameter("hostname"));
            if (hostname == null) {
                return FormValidation.ok();
            }
            SSHSite site = new SSHSite(hostname, request.getParameter("port"), request.getParameter("user"), request.getParameter("pass"), request.getParameter("keyfile"));
            try {
                try {
                    site.testConnection(System.out);
                }
                catch (JSchException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Can't connect to server");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

