/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.SSHUserInfo;

public class SSHSite {
    String hostname;
    int port;
    String username;
    String password;
    String keyfile;
    public static final Logger LOGGER = Logger.getLogger(SSHSite.class.getName());

    public SSHSite() {
    }

    public SSHSite(String hostname, String port, String username, String password) {
        this.hostname = hostname;
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
        this.username = username;
        this.password = password;
    }

    public SSHSite(String hostname, String port, String username, String passphrase, String keyfile) {
        this(hostname, port, username, passphrase);
        this.keyfile = keyfile;
    }

    public String getKeyfile() {
        return this.keyfile;
    }

    public void setKeyfile(String keyfile) {
        this.keyfile = keyfile;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return "" + this.port;
    }

    public void setPort(String port) {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
    }

    public int getIntegerPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.hostname;
    }

    private Session createSession(PrintStream logger) throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        if (this.keyfile != null && this.keyfile.length() > 0) {
            jsch.addIdentity(this.keyfile, this.password);
        } else {
            session.setPassword(this.password);
        }
        SSHUserInfo ui = new SSHUserInfo(this.password);
        session.setUserInfo((UserInfo)ui);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        return session;
    }

    public void executeCommand(PrintStream logger, String command) {
        Session session = null;
        ChannelExec channel = null;
        try {
            session = this.createSession(logger);
            channel = this.createChannel(logger, session);
            channel.setCommand(command);
            channel.setOutputStream((OutputStream)logger);
            channel.setInputStream(null);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    logger.println(new String(tmp, 0, i));
                    continue;
                }
                if (channel.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {}
            }
            logger.println("[SSH] exit-status: " + channel.getExitStatus());
            this.closeSession(logger, session, channel);
        }
        catch (JSchException e) {
            logger.println("[SSH] Exception:" + e.getMessage());
            e.printStackTrace(logger);
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
            session = null;
        }
        catch (IOException e) {
            logger.println("[SSH] Exception:" + e.getMessage());
            e.printStackTrace(logger);
        }
    }

    public void testConnection(PrintStream logger) throws JSchException, IOException {
        Session session = this.createSession(logger);
        this.closeSession(logger, session, null);
    }

    private ChannelExec createChannel(PrintStream logger, Session session) throws JSchException {
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        return channel;
    }

    private void closeSession(PrintStream logger, Session session, ChannelExec channel) {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    public String toString() {
        return "SSHSite [hostname=" + this.hostname + ", keyfile=" + this.keyfile + ", port=" + this.port + ", username=" + this.username + "]";
    }
}

