/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.status_view;

import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusView
extends ListView {
    private boolean stable;
    private boolean unstable;
    private boolean failed;
    private boolean aborted;
    private boolean running;

    @DataBoundConstructor
    public StatusView(String name) {
        super(name);
    }

    public boolean isStable() {
        return this.stable;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized List<TopLevelItem> getItems() {
        List base = super.getItems();
        ArrayList<TopLevelItem> result = new ArrayList<TopLevelItem>(base.size());
        for (TopLevelItem item : base) {
            Result status;
            if (!(item instanceof Job) || this.running && !((Job)item).isBuilding()) continue;
            Run lastBuild = ((Job)item).getLastCompletedBuild();
            Result result2 = status = lastBuild != null ? lastBuild.getResult() : null;
            if (!(this.stable && status == Result.SUCCESS || this.unstable && status == Result.UNSTABLE || this.failed && status == Result.FAILURE || this.aborted && status == Result.ABORTED) && (!this.running || status != null)) continue;
            result.add(item);
        }
        return result;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException {
        this.stable = req.hasParameter("status_view.stable");
        this.unstable = req.hasParameter("status_view.unstable");
        this.failed = req.hasParameter("status_view.failed");
        this.aborted = req.hasParameter("status_view.aborted");
        this.running = req.hasParameter("status_view.running");
        super.submit(req);
    }
}

