/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.statusmonitor;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.RootAction;
import hudson.plugins.statusmonitor.PluginImpl;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class MonitorAction
implements RootAction {
    private static final long serialVersionUID = 1L;
    private static final int COLUMNS = 2;

    public String getDisplayName() {
        return "Status Monitor";
    }

    public String getIconFileName() {
        return "/plugin/statusmonitor/icons/monitor-22x22.png";
    }

    public String getUrlName() {
        return "/monitor";
    }

    private List<Project> getProjects() {
        ArrayList<Project> result = new ArrayList<Project>();
        List projects = Hudson.getInstance().getProjects();
        for (Project project : projects) {
            Publisher publisher = project.getPublisher((Descriptor)PluginImpl.MONITOR_PUBLISHER_DESCRIPTOR);
            if (publisher == null) continue;
            result.add(project);
        }
        return result;
    }

    public String getResult(Project project) {
        String result = null;
        result = project.getLastCompletedBuild() != null && project.getLastCompletedBuild().getResult() != null ? (project.isDisabled() ? "DISABLED" : project.getLastCompletedBuild().getResult().toString()) : "NOT_BUILD";
        return result;
    }

    private int getRows() {
        int size = this.getProjects().size();
        if (size <= 3) {
            return size;
        }
        return size % 2 == 0 ? size / 2 : (size + 1) / 2;
    }

    @Exported
    public double getRowsHeight() {
        return 100.0 / new Double(this.getRows());
    }

    @Exported
    public Project[][] getProjectsArray() {
        int rows = this.getRows();
        Project[][] result = new Project[rows][];
        List projects = this.getProjects();
        for (int i = 0; i < rows; ++i) {
            Project[] row = result[i];
            if (row != null) continue;
            if (projects.size() <= 3) {
                row = new Project[]{(Project)projects.get(i)};
            } else if (i + 1 == rows && projects.size() % 2 != 0) {
                row = new Project[]{(Project)projects.get(i * 2)};
            } else {
                row = new Project[2];
                for (int j = 0; j < 2; ++j) {
                    row[j] = (Project)projects.get(i * 2 + j);
                }
            }
            result[i] = row;
        }
        return result;
    }

    @Exported
    public int getStyleId(LoopTagStatus varStatus, Project[][] projectsArray) {
        boolean oneDimenional;
        boolean lastLine = varStatus.isLast() && projectsArray.length > 1 && projectsArray[projectsArray.length - 1].length == 1;
        boolean bl = oneDimenional = projectsArray[0].length == 1;
        if (oneDimenional || lastLine) {
            return 1;
        }
        return 2;
    }
}

