/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.statusmonitor;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.plugins.statusmonitor.MonitorPublisher;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class MonitorAction
implements RootAction {
    private static final long serialVersionUID = 1L;
    private static final int COLUMNS = 2;

    public String getDisplayName() {
        return "Status Monitor";
    }

    public String getIconFileName() {
        return "/plugin/statusmonitor/icons/monitor-22x22.png";
    }

    public String getUrlName() {
        return "/monitor";
    }

    private List<AbstractProject> getProjects() {
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        List topLevelItems = Hudson.getInstance().getItems();
        for (TopLevelItem topLevelItem : topLevelItems) {
            AbstractProject abstractProject;
            if (!(topLevelItem instanceof AbstractProject) || (abstractProject = (AbstractProject)topLevelItem).getPublishersList().get((Descriptor)MonitorPublisher.DESCRIPTOR) == null) continue;
            result.add(abstractProject);
        }
        return result;
    }

    public String getResult(AbstractProject project) {
        String result = project.getLastCompletedBuild() != null && project.getLastCompletedBuild().getResult() != null ? (project.isDisabled() ? "DISABLED" : project.getLastCompletedBuild().getResult().toString()) : "NOT_BUILD";
        return result;
    }

    private int getRows() {
        int size = this.getProjects().size();
        if (size <= 3) {
            return size;
        }
        return size % 2 == 0 ? size / 2 : (size + 1) / 2;
    }

    @Exported
    public double getRowsHeight() {
        return 100.0 / new Double(this.getRows());
    }

    @Exported
    public AbstractProject[][] getProjectsArray() {
        int rows = this.getRows();
        AbstractProject[][] result = new AbstractProject[rows][];
        List<AbstractProject> projects = this.getProjects();
        for (int i = 0; i < rows; ++i) {
            AbstractProject[] row = result[i];
            if (row != null) continue;
            if (projects.size() <= 3) {
                row = new AbstractProject[]{projects.get(i)};
            } else if (i + 1 == rows && projects.size() % 2 != 0) {
                row = new AbstractProject[]{projects.get(i * 2)};
            } else {
                row = new AbstractProject[2];
                for (int j = 0; j < 2; ++j) {
                    row[j] = projects.get(i * 2 + j);
                }
            }
            result[i] = row;
        }
        return result;
    }

    @Exported
    public int getStyleId(LoopTagStatus varStatus, AbstractProject[][] projectsArray) {
        boolean oneDimenional;
        boolean lastLine = varStatus.isLast() && projectsArray.length > 1 && projectsArray[projectsArray.length - 1].length == 1;
        boolean bl = oneDimenional = projectsArray[0].length == 1;
        if (oneDimenional || lastLine) {
            return 1;
        }
        return 2;
    }
}

