/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Sventon2
extends SubversionRepositoryBrowser {
    public final URL url;
    private final String repositoryInstance;
    private static final String URL_CHARSET = "UTF-8";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Sventon2(URL url, String repositoryInstance) throws MalformedURLException {
        this.url = Sventon2.normalizeToEndWithSlash((URL)url);
        repositoryInstance = repositoryInstance.trim();
        this.repositoryInstance = repositoryInstance == null ? "" : repositoryInstance;
    }

    public String getRepositoryInstance() {
        return this.repositoryInstance;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/diff/%s?revision=%d", this.repositoryInstance, Sventon2.encodePath(this.getPath(path)), r));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/goto/%s?revision=%d", this.repositoryInstance, Sventon2.encodePath(this.getPath(path)), r));
    }

    private String getPath(SubversionChangeLogSet.Path path) {
        String s = Sventon2.trimHeadSlash((String)path.getValue());
        if (s.startsWith(this.repositoryInstance)) {
            s = Sventon2.trimHeadSlash((String)s.substring(this.repositoryInstance.length()));
        }
        return s;
    }

    private static String encodePath(String path) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String pathElement : path.split("/")) {
            if (first) {
                first = false;
            } else {
                buf.append('/');
            }
            buf.append(URLEncoder.encode(pathElement, URL_CHARSET));
        }
        if (path.endsWith("/")) {
            buf.append('/');
        }
        return buf.toString();
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format("repos/%s/info?revision=%d", this.repositoryInstance, changeSet.getRevision()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Sventon 2.x";
        }

        public FormValidation doCheckUrl(@AncestorInPath AbstractProject project, final @QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = value;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "sventon 2")) {
                            return FormValidation.ok();
                        }
                        if (this.findText(this.open(new URL(v)), "sventon")) {
                            return FormValidation.error((String)"This is a valid Sventon URL but it doesn't look like Sventon 2.x");
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Sventon");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

