/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.Messages;
import hudson.scm.SCM;
import hudson.scm.SubversionChangeLogBuilder;
import hudson.scm.SubversionChangeLogParser;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionSCM;
import hudson.scm.SubversionTagAction;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SubversionSCM
extends SCM
implements Serializable {
    private ModuleLocation[] locations = new ModuleLocation[0];
    private boolean useUpdate;
    private final SubversionRepositoryBrowser browser;
    private String excludedRegions;
    @Deprecated
    private String modules;
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER;
    public static int DEFAULT_TIMEOUT;

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        this(remoteLocations, localLocations, useUpdate, browser, null);
    }

    public SubversionSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        this(ModuleLocation.parse((String[])remoteLocations, (String[])localLocations), useUpdate, browser, excludedRegions);
    }

    @DataBoundConstructor
    public SubversionSCM(List<ModuleLocation> locations, boolean useUpdate, SubversionRepositoryBrowser browser, String excludedRegions) {
        Iterator<ModuleLocation> itr = locations.iterator();
        while (itr.hasNext()) {
            ModuleLocation ml = itr.next();
            if (ml.remote != null) continue;
            itr.remove();
        }
        this.locations = locations.toArray(new ModuleLocation[locations.size()]);
        this.useUpdate = useUpdate;
        this.browser = browser;
        this.excludedRegions = excludedRegions;
    }

    public SubversionSCM(String svnUrl) {
        this(new String[]{svnUrl}, new String[]{null}, true, null, null);
    }

    public String getModules() {
        return null;
    }

    public ModuleLocation[] getLocations() {
        return this.getLocations(null);
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(build);
        }
        return outLocations;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excludedRegions = this.getExcludedRegionsNormalized();
        if (excludedRegions != null) {
            Pattern[] patterns = new Pattern[excludedRegions.length];
            int i = 0;
            for (String excludedRegion : excludedRegions) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return null;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] locations = this.getLocations(build);
        try {
            Long rev;
            Map revisions = SubversionSCM.parseRevisionFile((AbstractBuild)build);
            if (locations.length == 1 && (rev = (Long)revisions.get(locations[0].remote)) != null) {
                env.put("SVN_REVISION", rev.toString());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new SubversionChangeLogBuilder(build, listener, this).run(externals, (Result)new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild build) throws IOException {
        HashMap<String, Long> revisions;
        block8: {
            revisions = new HashMap<String, Long>();
            File file = SubversionSCM.getRevisionFile((AbstractBuild)build);
            if (!file.exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block5: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.parseLong(line.substring(index + 1)));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) throws IOException {
        File file = SubversionSCM.getExternalsFile((AbstractProject)project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.access$000(), file).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List externals = this.checkout(build, workspace, (TaskListener)listener);
        if (externals == null) {
            return false;
        }
        PrintWriter w = new PrintWriter(new FileOutputStream(SubversionSCM.getRevisionFile((AbstractBuild)build)));
        try {
            Map revMap = (Map)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, (TaskListener)listener, externals));
            for (Map.Entry e : revMap.entrySet()) {
                w.println((String)e.getKey() + '/' + ((SvnInfo)e.getValue()).revision);
            }
            build.addAction((Action)new SubversionTagAction(build, revMap.values()));
        }
        finally {
            w.close();
        }
        new XmlFile(External.access$000(), SubversionSCM.getExternalsFile((AbstractProject)build.getProject())).write((Object)externals);
        return this.calcChangeLog(build, changelogFile, listener, externals);
    }

    private List<External> checkout(AbstractBuild build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            if (!this.repositoryLocationsExist(build, listener) && build.getProject().getLastSuccessfulBuild() != null) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getProject().getName() + ", project will be disabled.");
                build.getProject().makeDisabled(true);
                return null;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return null;
        }
        Boolean isUpdatable = this.useUpdate && (Boolean)workspace.act((FilePath.FileCallable)new IsUpdatableTask(build, this, listener)) != false;
        return (List)workspace.act((FilePath.FileCallable)new CheckOutTask(build, this, build.getTimestamp().getTime(), isUpdatable.booleanValue(), listener));
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam);
    }

    public static SVNClientManager createSvnClientManager() {
        return SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).createAuthenticationProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(File workspace, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(workspace, SVNRevision.WORKING);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        try {
            if (!this.repositoryLocationsExist(lastBuild, listener)) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + project + ", project will be disabled.");
                project.makeDisabled(true);
                return false;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return false;
        }
        Map wsRev = SubversionSCM.parseRevisionFile((AbstractBuild)lastBuild);
        List externals = SubversionSCM.parseExternalsFile((AbstractProject)project);
        for (ModuleLocation loc : this.getLocations(lastBuild)) {
            if (wsRev.containsKey(loc.getURL())) continue;
            listener.getLogger().println("Workspace doesn't contain " + loc.getURL() + ". Need a new build");
            return true;
        }
        ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider();
        block8: for (Map.Entry localInfo : wsRev.entrySet()) {
            String url = (String)localInfo.getKey();
            for (External ext : externals) {
                if (!ext.url.equals(url) || !ext.isRevisionFixed()) continue;
                continue block8;
            }
            try {
                SVNURL decodedURL = SVNURL.parseURIDecoded((String)url);
                SvnInfo remoteInfo = new SvnInfo(SubversionSCM.parseSvnInfo((SVNURL)decodedURL, (ISVNAuthenticationProvider)authProvider));
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_remoteRevisionAt((Object)url, (Object)remoteInfo.revision));
                if (remoteInfo.revision <= (Long)localInfo.getValue()) continue;
                boolean changesFound = true;
                Pattern[] excludedPatterns = this.getExcludedRegionsPatterns();
                if (excludedPatterns != null) {
                    SVNLogHandler handler = new SVNLogHandler(this, excludedPatterns, null);
                    SVNClientManager manager = SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
                    try {
                        SVNLogClient svnlc = manager.getLogClient();
                        svnlc.doLog(decodedURL, null, SVNRevision.UNDEFINED, SVNRevision.create((long)((Long)localInfo.getValue() + 1L)), SVNRevision.create((long)remoteInfo.revision), false, true, 0L, (ISVNLogEntryHandler)handler);
                    }
                    finally {
                        manager.dispose();
                    }
                    changesFound = handler.isChangesFound();
                }
                if (!changesFound) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_changedFrom(localInfo.getValue()));
                return true;
            }
            catch (SVNException e) {
                e.printStackTrace(listener.error("Failed to check repository revision for " + url));
            }
        }
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].getLocalDir());
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].getLocalDir());
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsExist(AbstractBuild<?, ?> build, TaskListener listener) throws SVNException {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(build)) {
            if (this.getDescriptor().checkRepositoryPath(l.getSVNURL()) != SVNNodeKind.NONE) continue;
            out.println("Location '" + l.remote + "' does not exist");
            ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null) {
                out.println("Location could be expanded on build '" + build + "' parameters values:");
                for (ParameterValue paramValue : params) {
                    out.println("  " + paramValue);
                }
            }
            return false;
        }
        return true;
    }

    public static void init() {
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        Level lv = level;
        com.trilead.ssh2.log.Logger.enabled = true;
        com.trilead.ssh2.log.Logger.logger = new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ SVNInfo access$200(File x0, ISVNAuthenticationProvider x1) throws SVNException {
        return SubversionSCM.parseSvnInfo((File)x0, (ISVNAuthenticationProvider)x1);
    }

    static /* synthetic */ String access$800(String x0) {
        return SubversionSCM.getLastPathComponent((String)x0);
    }

    static {
        new Initializer(null);
        LOGGER = Logger.getLogger(SubversionSCM.class.getName());
        DEFAULT_TIMEOUT = Integer.getInteger(SubversionSCM.class.getName() + ".timeout", 3600000);
    }
}

