/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.Hudson;
import hudson.security.csrf.CrumbIssuer;
import hudson.util.IOException2;
import hudson.util.MultipartFormDataParser;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

public class UserProvidedCredential
implements Closeable {
    private final String username;
    private final String password;
    private final File keyFile;
    private static final Logger LOGGER = Logger.getLogger(UserProvidedCredential.class.getName());

    public UserProvidedCredential(String username, String password, File keyFile) {
        this.username = username;
        this.password = password;
        this.keyFile = keyFile;
    }

    public static UserProvidedCredential fromForm(StaplerRequest req, MultipartFormDataParser parser) throws IOException {
        FileItem item;
        File keyFile;
        CrumbIssuer crumbIssuer = Hudson.getInstance().getCrumbIssuer();
        if (crumbIssuer != null && !crumbIssuer.validateCrumb((ServletRequest)req, parser)) {
            throw HttpResponses.error((int)403, (Throwable)new IOException("No crumb found"));
        }
        String kind = parser.get("kind");
        int idx = Arrays.asList("", "password", "publickey", "certificate").indexOf(kind);
        String username = parser.get("username" + idx);
        String password = parser.get("password" + idx);
        if (idx <= 1) {
            keyFile = null;
            item = null;
        } else {
            item = parser.getFileItem(kind.equals("publickey") ? "privateKey" : "certificate");
            keyFile = File.createTempFile("hudson", "key");
            if (item != null) {
                try {
                    item.write(keyFile);
                }
                catch (Exception e) {
                    throw new IOException2((Throwable)e);
                }
                if (PuTTYKey.isPuTTYKeyFile((File)keyFile)) {
                    LOGGER.info("Converting " + keyFile + " from PuTTY format to OpenSSH format");
                    new PuTTYKey(keyFile, null).toOpenSSH(keyFile);
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void close() throws IOException {
    }

    static /* synthetic */ String access$000(UserProvidedCredential x0) {
        return x0.username;
    }

    static /* synthetic */ String access$100(UserProvidedCredential x0) {
        return x0.password;
    }

    static /* synthetic */ File access$200(UserProvidedCredential x0) {
        return x0.keyFile;
    }
}

