/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.SubversionSCM;
import hudson.scm.UserProvidedCredential;
import hudson.scm.subversion.Messages;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class SubversionTagAction
extends AbstractScmTagAction
implements Describable<SubversionTagAction> {
    private final Map<SubversionSCM.SvnInfo, List<String>> tags = new CopyOnWriteMap.Tree();
    private static final Pattern TRUNK_BRANCH_MARKER = Pattern.compile("/(trunk|branches)(/|$)");

    SubversionTagAction(AbstractBuild build, Collection<SubversionSCM.SvnInfo> svnInfos) {
        super(build);
        HashMap m = new HashMap();
        for (SubversionSCM.SvnInfo si : svnInfos) {
            m.put(si, new ArrayList());
        }
        this.tags.putAll(m);
    }

    public boolean hasTags() {
        return this.isTagged();
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        int nonNullTag = 0;
        for (List<String> v : this.tags.values()) {
            if (!v.isEmpty() && ++nonNullTag > 1) break;
        }
        if (nonNullTag == 0) {
            return Messages.SubversionTagAction_DisplayName_HasNoTag();
        }
        if (nonNullTag == 1) {
            return Messages.SubversionTagAction_DisplayName_HasATag();
        }
        return Messages.SubversionTagAction_DisplayName_HasTags();
    }

    public Map<SubversionSCM.SvnInfo, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Exported(name="tags")
    public List<TagInfo> getTagInfo() {
        ArrayList<TagInfo> data = new ArrayList<TagInfo>();
        for (Map.Entry<SubversionSCM.SvnInfo, List<String>> e : this.tags.entrySet()) {
            String module = e.getKey().toString();
            for (String url : e.getValue()) {
                data.add(new TagInfo(module, url));
            }
        }
        return data;
    }

    public boolean isTagged() {
        for (List<String> t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getTooltip() {
        String tag = null;
        for (List<String> v : this.tags.values()) {
            for (String s : v) {
                if (tag != null) {
                    return Messages.SubversionTagAction_Tooltip();
                }
                tag = s;
            }
        }
        if (tag != null) {
            return Messages.SubversionTagAction_Tooltip_OneTag(tag);
        }
        return null;
    }

    public String makeTagURL(SubversionSCM.SvnInfo si) {
        Matcher m = TRUNK_BRANCH_MARKER.matcher(si.url);
        if (!m.find()) {
            return null;
        }
        return si.url.substring(0, m.start()) + "/tags/" + this.getBuild().getProject().getName() + "-" + this.getBuild().getNumber();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<SubversionSCM.SvnInfo, String> newTags = new HashMap<SubversionSCM.SvnInfo, String>();
        int i = -1;
        for (SubversionSCM.SvnInfo e : this.tags.keySet()) {
            if (this.tags.size() > 1 && parser.get("tag" + ++i) == null) continue;
            newTags.put(e, parser.get("name" + i));
        }
        UserProvidedCredential upc = null;
        if (parser.get("credential") != null) {
            upc = UserProvidedCredential.fromForm(req, parser);
        }
        new TagWorkerThread(newTags, upc).start();
        rsp.sendRedirect(".");
    }

    public Permission getPermission() {
        return SubversionSCM.TAG;
    }

    public Descriptor<SubversionTagAction> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SubversionTagAction> {
        public String getDisplayName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TagWorkerThread
    extends TaskThread {
        private final Map<SubversionSCM.SvnInfo, String> tagSet;
        private final UserProvidedCredential upc;

        public TagWorkerThread(Map<SubversionSCM.SvnInfo, String> tagSet, UserProvidedCredential upc) {
            super((TaskAction)SubversionTagAction.this, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
            this.upc = upc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void perform(TaskListener listener) {
            try {
                SVNClientManager sVNClientManager;
                if (this.upc != null) {
                    DefaultSVNOptions defaultSVNOptions = SVNWCUtil.createDefaultOptions((boolean)true);
                    UserProvidedCredential userProvidedCredential = this.upc;
                    userProvidedCredential.getClass();
                    sVNClientManager = SVNClientManager.newInstance((ISVNOptions)defaultSVNOptions, (ISVNAuthenticationManager)new UserProvidedCredential.AuthenticationManagerImpl(userProvidedCredential, listener));
                } else {
                    sVNClientManager = SubversionSCM.createSvnClientManager();
                }
                SVNClientManager cm = sVNClientManager;
                try {
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        PrintStream logger = listener.getLogger();
                        logger.println("Tagging " + e.getKey() + " to " + e.getValue());
                        try {
                            SVNURL src = SVNURL.parseURIDecoded((String)e.getKey().url);
                            SVNURL dst = SVNURL.parseURIDecoded((String)e.getValue());
                            SVNCopyClient svncc = cm.getCopyClient();
                            SVNRevision sourceRevision = SVNRevision.create((long)e.getKey().revision);
                            SVNCopySource csrc = new SVNCopySource(sourceRevision, sourceRevision, src);
                            svncc.doCopy(new SVNCopySource[]{csrc}, dst, false, true, false, "Tagged from " + SubversionTagAction.this.getBuild(), null);
                        }
                        catch (SVNException x) {
                            x.printStackTrace(listener.error("Failed to tag"));
                            cm.dispose();
                            return;
                        }
                    }
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        ((List)SubversionTagAction.this.tags.get(e.getKey())).add(e.getValue());
                    }
                    SubversionTagAction.this.getBuild().save();
                    SubversionTagAction.this.workerThread = null;
                }
                finally {
                    cm.dispose();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }

    @ExportedBean
    public static class TagInfo {
        private String module;
        private String url;

        private TagInfo(String module, String url) {
            this.module = module;
            this.url = url;
        }

        @Exported
        public String getModule() {
            return this.module;
        }

        @Exported
        public String getUrl() {
            return this.url;
        }
    }
}

