/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.scm.EditType;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.browsers.AbstractSventon;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sventon2
extends AbstractSventon {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Sventon2(URL url, String repositoryInstance) throws MalformedURLException {
        super(url, repositoryInstance);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/diff/%s?revision=%d", this.repositoryInstance, Sventon2.encodePath((String)this.getPath(path)), r));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/goto/%s?revision=%d", this.repositoryInstance, Sventon2.encodePath((String)this.getPath(path)), r));
    }

    private String getPath(SubversionChangeLogSet.Path path) {
        String s = Sventon2.trimHeadSlash((String)path.getValue());
        if (s.startsWith(this.repositoryInstance)) {
            s = Sventon2.trimHeadSlash((String)s.substring(this.repositoryInstance.length()));
        }
        return s;
    }

    private static String encodePath(String path) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String pathElement : path.split("/")) {
            if (first) {
                first = false;
            } else {
                buf.append('/');
            }
            buf.append(URLEncoder.encode(pathElement, "UTF-8"));
        }
        if (path.endsWith("/")) {
            buf.append('/');
        }
        return buf.toString();
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format("repos/%s/info?revision=%d", this.repositoryInstance, changeSet.getRevision()));
    }
}

