/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.User;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.tasks.MailAddressResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@Extension
public class SubversionMailAddressResolverImpl
extends MailAddressResolver {
    private static final Map<Pattern, String> RULE_TABLE = new HashMap();

    public String findMailAddressFor(User u) {
        for (AbstractProject p : u.getProjects()) {
            SCM scm = p.getScm();
            if (!(scm instanceof SubversionSCM)) continue;
            SubversionSCM svn = (SubversionSCM)scm;
            for (SubversionSCM.ModuleLocation loc : svn.getLocations((AbstractBuild)p.getLastBuild())) {
                String s = this.findMailAddressFor(u, loc.remote);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    protected String findMailAddressFor(User u, String scm) {
        for (Map.Entry e : RULE_TABLE.entrySet()) {
            if (!((Pattern)e.getKey()).matcher(scm).matches()) continue;
            return u.getId() + (String)e.getValue();
        }
        return null;
    }

    static {
        Pattern svnurl = Pattern.compile("https://[^.]+.dev.java.net/svn/([^/]+)(/.*)?");
        RULE_TABLE.put(svnurl, "@dev.java.net");
        Pattern svnUrl = Pattern.compile("(http|https)://[^.]+.svn.(sourceforge|sf).net/svnroot/([^/]+)(/.*)?");
        RULE_TABLE.put(svnUrl, "@users.sourceforge.net");
    }
}

