/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.Util;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.SubversionUpdateEventHandler;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class CheckoutUpdater
extends WorkspaceUpdater {
    @DataBoundConstructor
    public CheckoutUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new WorkspaceUpdater.UpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubversionSCM.External> perform() throws IOException, InterruptedException {
                SVNUpdateClient svnuc = this.manager.getUpdateClient();
                ArrayList<SubversionSCM.External> externals = new ArrayList<SubversionSCM.External>();
                this.listener.getLogger().println("Cleaning workspace " + this.ws.getCanonicalPath());
                Util.deleteContentsRecursive((File)this.ws);
                PipedOutputStream pos = new PipedOutputStream();
                StreamCopyThread sct = new StreamCopyThread("svn log copier", (InputStream)new PipedInputStream(pos), (OutputStream)this.listener.getLogger());
                sct.start();
                SubversionSCM.ModuleLocation location = null;
                try {
                    SubversionSCM.ModuleLocation[] arr$ = this.locations;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        SubversionSCM.ModuleLocation l;
                        location = l = arr$[i$];
                        this.listener.getLogger().println("Checking out " + l.remote);
                        File local = new File(this.ws, l.getLocalDir());
                        svnuc.setEventHandler((ISVNEventHandler)new SubversionUpdateEventHandler(new PrintStream(pos), externals, local, l.getLocalDir()));
                        svnuc.doCheckout(l.getSVNURL(), local.getCanonicalFile(), SVNRevision.HEAD, this.getRevision(l), SVNDepth.INFINITY, true);
                    }
                }
                catch (SVNException e) {
                    e.printStackTrace(this.listener.error("Failed to check out " + location.remote));
                    List<SubversionSCM.External> list = null;
                    return list;
                }
                finally {
                    try {
                        pos.close();
                    }
                    finally {
                        try {
                            sct.join();
                        }
                        catch (InterruptedException e) {
                            throw new IOException2("interrupted", (Throwable)e);
                        }
                    }
                }
                return externals;
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return "Always check out a fresh copy";
        }
    }
}

