/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;

public class SubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(SubversionRepositoryStatus.class.getName());

    public SubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        String line;
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        while ((line = new BufferedReader(req.getReader()).readLine()) != null) {
            LOGGER.finer("Reading line: " + line);
            affectedPath.add(line.substring(4));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        block3: for (AbstractProject p : Hudson.getInstance().getItems(AbstractProject.class)) {
            try {
                SCMTrigger trigger;
                SCM scm = p.getScm();
                if (!(scm instanceof SubversionSCM) || (trigger = (SCMTrigger)p.getTrigger(SCMTrigger.class)) == null) continue;
                SubversionSCM sscm = (SubversionSCM)scm;
                for (SubversionSCM.ModuleLocation loc : sscm.getLocations()) {
                    String n;
                    String m;
                    if (!loc.getUUID().equals(this.uuid) || !(m = loc.getSVNURL().getPath()).startsWith(n = loc.getRepositoryRoot().getPath())) continue;
                    String remaining = m.substring(n.length());
                    if (remaining.startsWith("/")) {
                        remaining = remaining.substring(1);
                    }
                    String remainingSlash = remaining + '/';
                    for (String path : affectedPath) {
                        if (!path.equals(remaining) && !path.startsWith(remainingSlash)) continue;
                        LOGGER.fine("Scheduling the immediate polling of " + p);
                        trigger.run();
                        continue block3;
                    }
                }
            }
            catch (SVNException e) {
                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
            }
        }
        rsp.setStatus(200);
    }
}

