/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionSCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubversionChangeLogSet
extends ChangeLogSet<LogEntry> {
    private final List<LogEntry> logs;
    private Map<String, Long> revisionMap;

    SubversionChangeLogSet(AbstractBuild build, List<LogEntry> logs) {
        super(build);
        Collections.sort(logs, new /* Unavailable Anonymous Inner Class!! */);
        this.logs = Collections.unmodifiableList(logs);
        for (LogEntry log : logs) {
            log.setParent((ChangeLogSet)this);
        }
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public List<LogEntry> getLogs() {
        return this.logs;
    }

    public Iterator<LogEntry> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "svn";
    }

    public synchronized Map<String, Long> getRevisionMap() throws IOException {
        if (this.revisionMap == null) {
            this.revisionMap = SubversionSCM.parseRevisionFile((AbstractBuild)this.build);
        }
        return this.revisionMap;
    }

    @Exported
    public List<RevisionInfo> getRevisions() throws IOException {
        ArrayList<RevisionInfo> r = new ArrayList<RevisionInfo>();
        for (Map.Entry e : this.getRevisionMap().entrySet()) {
            r.add(new RevisionInfo((String)e.getKey(), ((Long)e.getValue()).longValue()));
        }
        return r;
    }
}

