/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionTagAction
extends AbstractScmTagAction {
    private final Map<SubversionSCM.SvnInfo, List<String>> tags = new CopyOnWriteMap.Tree();
    private static final Pattern TRUNK_BRANCH_MARKER = Pattern.compile("/(trunk|branches)(/|$)");

    SubversionTagAction(AbstractBuild build, Collection<SubversionSCM.SvnInfo> svnInfos) {
        super(build);
        HashMap m = new HashMap();
        for (SubversionSCM.SvnInfo si : svnInfos) {
            m.put(si, new ArrayList());
        }
        this.tags.putAll(m);
    }

    public boolean hasTags() {
        for (Map.Entry<SubversionSCM.SvnInfo, List<String>> e : this.tags.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getIconFileName() {
        if (!this.hasTags() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        int nonNullTag = 0;
        for (List<String> v : this.tags.values()) {
            if (!v.isEmpty() && ++nonNullTag > 1) break;
        }
        if (nonNullTag == 0) {
            return Messages.SubversionTagAction_DisplayName_HasNoTag();
        }
        if (nonNullTag == 1) {
            return Messages.SubversionTagAction_DisplayName_HasATag();
        }
        return Messages.SubversionTagAction_DisplayName_HasTags();
    }

    public Map<SubversionSCM.SvnInfo, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public boolean isTagged() {
        for (List<String> t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getTooltip() {
        if (this.isTagged()) {
            return Messages.SubversionTagAction_Tooltip();
        }
        return null;
    }

    public String makeTagURL(SubversionSCM.SvnInfo si) {
        Matcher m = TRUNK_BRANCH_MARKER.matcher(si.url);
        if (!m.find()) {
            return null;
        }
        return si.url.substring(0, m.start()) + "/tags/" + this.getBuild().getProject().getName() + "-" + this.getBuild().getNumber();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        HashMap<SubversionSCM.SvnInfo, String> newTags = new HashMap<SubversionSCM.SvnInfo, String>();
        int i = -1;
        for (SubversionSCM.SvnInfo e : this.tags.keySet()) {
            if (this.tags.size() > 1 && req.getParameter("tag" + ++i) == null) continue;
            newTags.put(e, req.getParameter("name" + i));
        }
        new TagWorkerThread(newTags).start();
        rsp.sendRedirect(".");
    }

    public Permission getPermission() {
        return SubversionSCM.TAG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TagWorkerThread
    extends TaskThread {
        private final Map<SubversionSCM.SvnInfo, String> tagSet;

        public TagWorkerThread(Map<SubversionSCM.SvnInfo, String> tagSet) {
            super((TaskAction)SubversionTagAction.this, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void perform(TaskListener listener) {
            try {
                SVNClientManager cm = SubversionSCM.createSvnClientManager();
                try {
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        PrintStream logger = listener.getLogger();
                        logger.println("Tagging " + e.getKey() + " to " + e.getValue());
                        try {
                            SVNURL src = SVNURL.parseURIDecoded((String)e.getKey().url);
                            SVNURL dst = SVNURL.parseURIDecoded((String)e.getValue());
                            SVNCopyClient svncc = cm.getCopyClient();
                            SVNRevision sourceRevision = SVNRevision.create((long)e.getKey().revision);
                            SVNCopySource csrc = new SVNCopySource(sourceRevision, sourceRevision, src);
                            svncc.doCopy(new SVNCopySource[]{csrc}, dst, false, true, false, "Tagged from " + SubversionTagAction.this.getBuild(), null);
                        }
                        catch (SVNException x) {
                            x.printStackTrace(listener.error("Failed to tag"));
                            cm.dispose();
                            return;
                        }
                    }
                    for (Map.Entry<SubversionSCM.SvnInfo, String> e : this.tagSet.entrySet()) {
                        ((List)SubversionTagAction.this.tags.get(e.getKey())).add(e.getValue());
                    }
                    SubversionTagAction.this.getBuild().save();
                    SubversionTagAction.this.workerThread = null;
                }
                finally {
                    cm.dispose();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }
}

