/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class WebSVN
extends SubversionRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    public final URL url;

    @DataBoundConstructor
    public WebSVN(URL url) throws MalformedURLException {
        this.url = WebSVN.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, WebSVN.trimHeadSlash((String)path.getValue()) + this.param().add("op=diff").add("rev=" + r));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.url, WebSVN.trimHeadSlash((String)path.getValue()) + this.param());
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, "." + this.param().add("rev=" + changeSet.getRevision()).add("sc=1"));
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "WebSVN";
        }
    }
}

