/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.SubversionSCM;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubversionChangeLogSet
extends ChangeLogSet<LogEntry> {
    private final List<LogEntry> logs;
    private Map<String, Long> revisionMap;

    SubversionChangeLogSet(AbstractBuild build, List<LogEntry> logs) {
        super(build);
        Collections.sort(logs, new Comparator<LogEntry>(){

            @Override
            public int compare(LogEntry a, LogEntry b) {
                return b.getRevision() - a.getRevision();
            }
        });
        this.logs = Collections.unmodifiableList(logs);
        for (LogEntry log : logs) {
            log.setParent(this);
        }
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public List<LogEntry> getLogs() {
        return this.logs;
    }

    public Iterator<LogEntry> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "svn";
    }

    public synchronized Map<String, Long> getRevisionMap() throws IOException {
        if (this.revisionMap == null) {
            this.revisionMap = SubversionSCM.parseRevisionFile(this.build);
        }
        return this.revisionMap;
    }

    @Exported
    public List<RevisionInfo> getRevisions() throws IOException {
        ArrayList<RevisionInfo> r = new ArrayList<RevisionInfo>();
        for (Map.Entry<String, Long> e : this.getRevisionMap().entrySet()) {
            r.add(new RevisionInfo(e.getKey(), e.getValue()));
        }
        return r;
    }

    @ExportedBean(defaultVisibility=999)
    public static class Path
    implements ChangeLogSet.AffectedFile {
        private LogEntry entry;
        private char action;
        private String value;

        public LogEntry getLogEntry() {
            return this.entry;
        }

        public void setLogEntry(LogEntry entry) {
            this.entry = entry;
        }

        public void setAction(String action) {
            this.action = action.charAt(0);
        }

        @Exported(name="file")
        public String getValue() {
            return this.value;
        }

        public String getPath() {
            return this.getValue();
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Exported
        public EditType getEditType() {
            if (this.action == 'A') {
                return EditType.ADD;
            }
            if (this.action == 'D') {
                return EditType.DELETE;
            }
            return EditType.EDIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogEntry
    extends ChangeLogSet.Entry {
        private int revision;
        private User author;
        private String date;
        private String msg;
        private List<Path> paths = new ArrayList<Path>();

        public SubversionChangeLogSet getParent() {
            return (SubversionChangeLogSet)super.getParent();
        }

        protected void setParent(ChangeLogSet changeLogSet) {
            super.setParent(changeLogSet);
        }

        @Exported
        public int getRevision() {
            return this.revision;
        }

        public void setRevision(int revision) {
            this.revision = revision;
        }

        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return this.author;
        }

        public Collection<String> getAffectedPaths() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return LogEntry.this.preparePath(((Path)LogEntry.this.paths.get(index)).value);
                }

                @Override
                public int size() {
                    return LogEntry.this.paths.size();
                }
            };
        }

        private String preparePath(String path) {
            SubversionSCM scm = (SubversionSCM)this.getParent().build.getProject().getScm();
            SubversionSCM.ModuleLocation[] locations = scm.getLocations();
            for (int i = 0; i < locations.length; ++i) {
                String newPath;
                String commonPart = this.findCommonPart(locations[i].remote, path);
                if (commonPart == null) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((newPath = path.substring(commonPart.length())).startsWith("/")) {
                    newPath = newPath.substring(1);
                }
                return newPath;
            }
            return path;
        }

        private String findCommonPart(String folder, String filePath) {
            if (folder == null || filePath == null) {
                return null;
            }
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            for (int i = 0; i < folder.length(); ++i) {
                String part = folder.substring(i);
                if (!filePath.startsWith(part)) continue;
                return part;
            }
            return null;
        }

        public void setUser(String author) {
            this.author = User.get((String)author);
        }

        @Exported
        public String getUser() {
            return this.author != null ? this.author.getDisplayName() : "unknown";
        }

        @Exported
        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void addPath(Path p) {
            p.entry = this;
            this.paths.add(p);
        }

        @Exported
        public List<Path> getPaths() {
            return this.paths;
        }

        public Collection<Path> getAffectedFiles() {
            return this.paths;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static final class RevisionInfo {
        @Exported
        public final String module;
        @Exported
        public final long revision;

        public RevisionInfo(String module, long revision) {
            this.module = module;
            this.revision = revision;
        }
    }
}

