/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.Channel;
import hudson.scm.PerJobCredentialStore;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PerJobCredentialStore
implements Saveable,
SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider {
    private static final Logger LOGGER = Logger.getLogger(PerJobCredentialStore.class.getName());
    private static final ThreadLocal<Boolean> IS_SAVING = new ThreadLocal();
    private final transient AbstractProject<?, ?> project;
    private static final String credentialsFileName = "subversion.credentials";
    private transient CredentialsSaveableListener saveableListener;
    private final Map<String, SubversionSCM.DescriptorImpl.Credential> credentials = new Hashtable();

    PerJobCredentialStore(AbstractProject<?, ?> project) {
        this.project = project;
        XmlFile xml = this.getXmlFile();
        try {
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, Messages.PerJobCredentialStore_readCredentials_error((Object)xml), e);
        }
    }

    public synchronized SubversionSCM.DescriptorImpl.Credential get(String realm) {
        return (SubversionSCM.DescriptorImpl.Credential)this.credentials.get(realm);
    }

    public SubversionSCM.DescriptorImpl.Credential getCredential(SVNURL url, String realm) {
        return this.get(realm);
    }

    public void acknowledgeAuthentication(String realm, SubversionSCM.DescriptorImpl.Credential cred) {
        try {
            this.acknowledge(realm, cred);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, Messages.PerJobCredentialStore_acknowledgeAuthentication_error(), e);
        }
    }

    public synchronized void acknowledge(String realm, SubversionSCM.DescriptorImpl.Credential cred) throws IOException {
        SubversionSCM.DescriptorImpl.Credential old;
        SubversionSCM.DescriptorImpl.Credential credential = old = cred == null ? (SubversionSCM.DescriptorImpl.Credential)this.credentials.remove(realm) : this.credentials.put(realm, cred);
        if (old == null && cred == null) {
            return;
        }
        if (old == null || cred == null || !old.equals(cred)) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        IS_SAVING.set(Boolean.TRUE);
        try {
            if (!this.credentials.isEmpty()) {
                XmlFile xmlFile = this.getXmlFile();
                xmlFile.write((Object)this);
                SaveableListener.fireOnChange((Saveable)this, (XmlFile)xmlFile);
            }
        }
        finally {
            IS_SAVING.remove();
        }
    }

    private XmlFile getXmlFile() {
        return new XmlFile(new File(this.project.getRootDir(), credentialsFileName));
    }

    synchronized boolean isEmpty() {
        return this.credentials.isEmpty();
    }

    private Object writeReplace() {
        if (IS_SAVING.get() != null) {
            return this;
        }
        Channel c = Channel.current();
        return c == null ? this : (SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider)c.export(SubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider.class, (Object)this);
    }

    protected CredentialsSaveableListener getSaveableListener() {
        ExtensionList extensionList;
        if (null == this.saveableListener && null != (extensionList = Hudson.getInstance().getExtensionList(SaveableListener.class)) && !extensionList.isEmpty()) {
            for (SaveableListener listener : extensionList) {
                if (!(listener instanceof CredentialsSaveableListener)) continue;
                this.saveableListener = (CredentialsSaveableListener)listener;
                break;
            }
        }
        return this.saveableListener;
    }
}

