/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.FoldableAction;
import hudson.scm.SubversionSCM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionParameterAction
extends InvisibleAction
implements Serializable,
FoldableAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RevisionParameterAction.class.getName());
    private final List<SubversionSCM.SvnInfo> revisions;

    public RevisionParameterAction(List<SubversionSCM.SvnInfo> revisions) {
        this.revisions = revisions;
    }

    public RevisionParameterAction(RevisionParameterAction action) {
        this.revisions = new ArrayList<SubversionSCM.SvnInfo>(action.revisions);
    }

    public RevisionParameterAction(SubversionSCM.SvnInfo ... revisions) {
        this.revisions = new ArrayList<SubversionSCM.SvnInfo>(Arrays.asList(revisions));
    }

    public List<SubversionSCM.SvnInfo> getRevisions() {
        return this.revisions;
    }

    public SVNRevision getRevision(String url) {
        for (SubversionSCM.SvnInfo revision : this.revisions) {
            if (!revision.url.equals(url)) continue;
            return SVNRevision.create((long)revision.revision);
        }
        return null;
    }

    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        RevisionParameterAction existing = (RevisionParameterAction)item.getAction(RevisionParameterAction.class);
        if (existing != null) {
            existing.mergeRevisions(this.revisions);
            return;
        }
        item.getActions().add(new RevisionParameterAction(this));
    }

    private void mergeRevisions(List<SubversionSCM.SvnInfo> newRevisions) {
        for (SubversionSCM.SvnInfo newRev : newRevisions) {
            boolean found = false;
            for (SubversionSCM.SvnInfo oldRev : this.revisions) {
                if (!oldRev.url.equals(newRev.url)) continue;
                LOGGER.info("Updating revision parameter for " + oldRev.url + " from " + oldRev.revision + " to " + newRev.revision);
                this.revisions.add(new SubversionSCM.SvnInfo(oldRev.url, newRev.revision));
                this.revisions.remove(oldRev);
                found = true;
                break;
            }
            if (found) continue;
            this.revisions.add(newRev);
        }
    }

    public String toString() {
        String result = "[RevisionParameterAction ";
        for (SubversionSCM.SvnInfo i : this.revisions) {
            result = result + i.url + "(" + i.revision + ") ";
        }
        return result + "]";
    }
}

