/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;

public abstract class AbstractSventon
extends SubversionRepositoryBrowser {
    public final URL url;
    protected final String repositoryInstance;
    protected static final String URL_CHARSET = "UTF-8";

    public AbstractSventon(URL url, String repositoryInstance) throws MalformedURLException {
        this.url = AbstractSventon.normalizeToEndWithSlash((URL)url);
        repositoryInstance = repositoryInstance.trim();
        this.repositoryInstance = repositoryInstance == null ? "" : repositoryInstance;
    }

    public String getRepositoryInstance() {
        return this.repositoryInstance;
    }

    protected static class SventonUrlChecker
    extends FormValidation.URLCheck {
        private String url;
        private Integer version;

        public SventonUrlChecker(String url, Integer version) {
            this.url = url;
            this.version = version;
        }

        protected FormValidation check() throws IOException, ServletException {
            String v = this.url;
            if (!v.endsWith("/")) {
                v = v + '/';
            }
            try {
                if (this.findText(this.open(new URL(v)), "sventon " + this.version)) {
                    return FormValidation.ok();
                }
                if (this.findText(this.open(new URL(v)), "sventon")) {
                    return FormValidation.error((String)("This is a valid Sventon URL but it doesn't look like Sventon " + this.version + ".x"));
                }
                return FormValidation.error((String)"This is a valid URL but it doesn't look like Sventon");
            }
            catch (IOException e) {
                return this.handleIOException(v, e);
            }
        }
    }
}

