/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.credential;

import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.SubversionSCM;
import hudson.scm.credential.Messages;
import hudson.util.Scrambler;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;

public class SshPublicKeyCredential
extends SubversionSCM.DescriptorImpl.Credential {
    private static final Logger LOGGER = Logger.getLogger(SubversionSCM.class.getName());
    private final String userName;
    private final String passphrase;
    private final String id;

    public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
        this.userName = userName;
        this.passphrase = Scrambler.scramble((String)passphrase);
        Random r = new Random();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            buf.append(Integer.toHexString(r.nextInt(16)));
        }
        this.id = buf.toString();
        try {
            File savedKeyFile = this.getKeyFile();
            FileUtils.copyFile((File)keyFile, (File)savedKeyFile);
            this.setFilePermissions(savedKeyFile, "600");
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)Messages.SshPublicKeyCredential_private_key_save_error()), (Throwable)e);
        }
    }

    private File getKeyFile() {
        File dir = new File(Hudson.getInstance().getRootDir(), Messages.SshPublicKeyCredential_private_key());
        if (dir.mkdirs()) {
            this.setFilePermissions(dir, Messages.SshPublicKeyCredential_private_key_permissions());
        }
        return new File(dir, this.id);
    }

    private boolean setFilePermissions(File file, String perms) {
        try {
            Chmod chmod = new Chmod();
            chmod.setProject(new Project());
            chmod.setFile(file);
            chmod.setPerm(perms);
            chmod.execute();
        }
        catch (BuildException e) {
            LOGGER.log(Level.WARNING, Messages.SshPublicKeyCredential_private_key_set_permissions_error((Object)file), e);
            return false;
        }
        return true;
    }

    public SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
        if (kind.equals("svn.ssh")) {
            try {
                Channel channel = Channel.current();
                String privateKey = channel != null ? (String)channel.call((Callable)new /* Unavailable Anonymous Inner Class!! */) : FileUtils.readFileToString((File)this.getKeyFile(), (String)Messages.SshPublicKeyCredential_private_key_encoding());
                return new SVNSSHAuthentication(this.userName, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false);
            }
            catch (IOException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)Messages.SshPublicKeyCredential_private_key_load_error()), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)Messages.SshPublicKeyCredential_private_key_load_error()), (Throwable)e);
            }
        }
        return null;
    }

    static /* synthetic */ File access$000(SshPublicKeyCredential x0) {
        return x0.getKeyFile();
    }
}

