/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.remoting.Which;
import hudson.scm.SubversionEventHandlerImpl;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class SubversionUpdateEventHandler
extends SubversionEventHandlerImpl {
    private static final Logger LOGGER = Logger.getLogger(SubversionUpdateEventHandler.class.getName());
    private final List<SubversionSCM.External> externals;
    private final String modulePath;

    public SubversionUpdateEventHandler(PrintStream out, List<SubversionSCM.External> externals, File moduleDir, String modulePath) {
        super(out, moduleDir);
        this.externals = externals;
        this.modulePath = modulePath;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        SVNEventAction action;
        File file = event.getFile();
        String path = null;
        if (file != null) {
            try {
                path = this.getRelativePath(file);
            }
            catch (IOException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL), (Throwable)e);
            }
            path = SubversionUpdateEventHandler.getLocalPath((String)path);
        }
        if ((action = event.getAction()) == SVNEventAction.UPDATE_EXTERNAL) {
            SVNExternal ext = event.getExternalInfo();
            if (ext == null) {
                URL jarFile = null;
                try {
                    jarFile = Which.jarURL(SVNEvent.class);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Exception occurred while loading SVNEvent", e);
                }
                this.out.println("AssertionError: appears to be using unpatched svnkit at " + jarFile);
            } else {
                this.out.println(Messages.SubversionUpdateEventHandler_FetchExternal((Object)ext.getResolvedURL(), (Object)ext.getRevision().getNumber(), (Object)event.getFile()));
                this.externals.add(new SubversionSCM.External(this.modulePath + "/" + path.substring(0, path.length() - ext.getPath().length()), ext));
            }
            return;
        }
        if (action == SVNEventAction.SKIP && event.getExpectedAction() == SVNEventAction.UPDATE_EXTERNAL && event.getNodeKind() == SVNNodeKind.FILE) {
            this.out.println("svn:externals to a file requires Subversion 1.6 workspace support. Use the system configuration to enable that.");
        }
        super.handleEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        if (Thread.interrupted()) {
            throw new SVNCancelException();
        }
    }
}

