/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.credential;

import com.trilead.ssh2.crypto.Base64;
import hudson.scm.SubversionSCM;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;

public class SslClientCertificateCredential
extends SubversionSCM.DescriptorImpl.Credential {
    private final Secret certificate;
    private final String password;

    public SslClientCertificateCredential(File certificate, String password) throws IOException {
        this.password = Scrambler.scramble((String)password);
        this.certificate = Secret.fromString((String)new String(Base64.encode((byte[])FileUtils.readFileToByteArray((File)certificate))));
    }

    public SVNAuthentication createSVNAuthentication(String kind) {
        if (kind.equals("svn.ssl.client-passphrase")) {
            try {
                return new SVNSSLAuthentication(Base64.decode((char[])this.certificate.getPlainText().toCharArray()), Scrambler.descramble((String)this.password), false);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return null;
    }
}

