/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.CheckoutUpdater;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SubversionUpdateEventHandler;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import hudson.triggers.SCMTrigger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class UpdateUpdater
extends WorkspaceUpdater {
    @DataBoundConstructor
    public UpdateUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new TaskImpl();
    }

    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.UpdateUpdater_DisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskImpl
    extends WorkspaceUpdater.UpdateTask {
        protected boolean isUpdatable() throws IOException {
            for (SubversionSCM.ModuleLocation l : this.locations) {
                String moduleName = l.getLocalDir();
                File module = new File(this.ws, moduleName).getCanonicalFile();
                if (!module.exists()) {
                    this.listener.getLogger().println("Checking out a fresh workspace because " + module + " doesn't exist");
                    return false;
                }
                try {
                    SVNInfo svnkitInfo = this.parseSvnInfo(module);
                    SubversionSCM.SvnInfo svnInfo = new SubversionSCM.SvnInfo(svnkitInfo);
                    String url = l.getURL();
                    if (svnInfo.url.equals(url)) continue;
                    this.listener.getLogger().println("Checking out a fresh workspace because the workspace is not " + url);
                    return false;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.listener.getLogger().println("Checking out a fresh workspace because there's no workspace at " + module);
                    } else {
                        this.listener.getLogger().println("Checking out a fresh workspace because Hudson failed to detect the current workspace " + module);
                        e.printStackTrace(this.listener.error(e.getMessage()));
                    }
                    return false;
                }
            }
            return true;
        }

        private SVNInfo parseSvnInfo(File workspace) throws SVNException {
            SVNWCClient svnWc = this.manager.getWCClient();
            return svnWc.doInfo(workspace, SVNRevision.WORKING);
        }

        @Override
        public List<SubversionSCM.External> perform() throws IOException, InterruptedException {
            if (!this.isUpdatable()) {
                return this.delegateTo(new CheckoutUpdater());
            }
            SVNUpdateClient svnuc = this.manager.getUpdateClient();
            ArrayList<SubversionSCM.External> externals = new ArrayList<SubversionSCM.External>();
            for (SubversionSCM.ModuleLocation l : this.locations) {
                try {
                    File local = new File(this.ws, l.getLocalDir());
                    svnuc.setEventHandler((ISVNEventHandler)new SubversionUpdateEventHandler(this.listener.getLogger(), externals, local, l.getLocalDir()));
                    svnuc.setIgnoreExternals(l.isIgnoreExternalsOption());
                    this.preUpdate(l, local);
                    SVNDepth svnDepth = TaskImpl.getSvnDepth(l.getDepthOption());
                    SVNRevision revision = this.getRevision(l);
                    this.listener.getLogger().println("Updating " + l.remote + " revision: " + (revision != null ? revision.toString() : "null") + " depth:" + svnDepth + " ignoreExternals: " + l.isIgnoreExternalsOption());
                    svnuc.doUpdate(local.getCanonicalFile(), revision, svnDepth, true, false);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        this.listener.getLogger().println("Workspace appear to be locked, so getting a fresh workspace");
                        return this.delegateTo(new CheckoutUpdater());
                    }
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_OBSTRUCTED_UPDATE) {
                        this.listener.getLogger().println(e.getMessage());
                        this.listener.getLogger().println("Updated failed due to local files. Getting a fresh workspace");
                        return this.delegateTo(new CheckoutUpdater());
                    }
                    e.printStackTrace(this.listener.error("Failed to update " + l.remote));
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                        this.listener.getLogger().println("Polled jobs are " + ((SCMTrigger.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SCMTrigger.DescriptorImpl.class)).getItemsBeingPolled());
                    }
                    return null;
                }
            }
            return externals;
        }

        protected void preUpdate(SubversionSCM.ModuleLocation module, File local) throws SVNException, IOException {
        }
    }
}

