/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_release_mgr.model;

import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.scm.SubversionTagAction;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLogEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Revision {
    private Map<Long, Run> builds = new HashMap();
    private SVNLogEntry logEntry;
    private static final String SVN_REVISION_KEY = "SVN_REVISION";
    private static final String BUILD_NUMBER_KEY = "BUILD_NUMBER";

    public Revision(SVNLogEntry logEntry) {
        this.logEntry = logEntry;
    }

    public SVNLogEntry getLogEntry() {
        return this.logEntry;
    }

    public void setLogEntry(SVNLogEntry logEntry) {
        this.logEntry = logEntry;
    }

    public Map<Long, Run> getBuilds() {
        return this.builds;
    }

    public void addBuild(Run r) {
        this.builds.put(Revision.getBuildNumber((Run)r), r);
    }

    public boolean hasTagAction(Long buildNum) {
        boolean hasTagAction = false;
        for (Object o : ((Run)this.builds.get(buildNum)).getBadgeActions()) {
            BuildBadgeAction ba = (BuildBadgeAction)o;
            if (!(ba instanceof SubversionTagAction)) continue;
            hasTagAction = true;
        }
        return hasTagAction;
    }

    public static Long getBuildNumber(Run r) {
        return Long.parseLong((String)r.getEnvVars().get("BUILD_NUMBER"));
    }

    public static String getBuildUrl(Run r) {
        return Hudson.getInstance().getRootUrl() + r.getUrl();
    }

    public static Long getRevisionNumber(Run r) {
        Long rev = null;
        String revString = (String)r.getEnvVars().get("SVN_REVISION");
        if (revString != null) {
            rev = Long.parseLong(revString);
        }
        return rev;
    }
}

