/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.remoting.Which;
import hudson.scm.Messages;
import hudson.scm.SubversionEventHandlerImpl;
import hudson.scm.SubversionReleaseSCM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
final class SubversionReleaseUpdateEventHandler
extends SubversionEventHandlerImpl {
    private final List<SubversionReleaseSCM.External> externals;
    private final String modulePath;

    public SubversionReleaseUpdateEventHandler(PrintStream out, List<SubversionReleaseSCM.External> externals, File moduleDir, String modulePath) {
        super(out, moduleDir);
        this.externals = externals;
        this.modulePath = modulePath;
    }

    public void handleEvent(SVNEvent event, double progress) {
        SVNEventAction action;
        File file = event.getFile();
        String path = null;
        if (file != null) {
            path = this.getRelativePath(file);
            path = SubversionReleaseUpdateEventHandler.getLocalPath((String)path);
        }
        if ((action = event.getAction()) == SVNEventAction.UPDATE_EXTERNAL) {
            SVNExternal ext = event.getExternalInfo();
            if (ext == null) {
                URL jarFile = null;
                try {
                    jarFile = Which.jarURL(SVNEvent.class);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.out.println("AssertionError: appears to be using unpatched svnkit at " + jarFile);
            } else {
                this.out.println(Messages.SubversionUpdateEventHandler_FetchExternal((Object)ext.getResolvedURL(), (Object)ext.getRevision().getNumber(), (Object)event.getFile()));
                this.externals.add(new SubversionReleaseSCM.External(this.modulePath + "/" + path.substring(0, path.length() - ext.getPath().length()), ext));
            }
            return;
        }
        super.handleEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        if (Thread.interrupted()) {
            throw new SVNCancelException();
        }
    }
}

