/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_release_mgr;

import hudson.EnvVars;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Hudson;
import hudson.model.ParametersAction;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.svn_release_mgr.JobPropertyImpl;
import hudson.plugins.svn_release_mgr.model.Revision;
import hudson.scm.SubversionReleaseSCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectReleaseAction
implements ProminentProjectAction {
    private AbstractProject<?, ?> owner;
    private JobPropertyImpl property;
    private String[] compare;
    private String revision;
    private static final Logger LOGGER = Logger.getLogger(ProjectReleaseAction.class.getName());

    public ProjectReleaseAction(AbstractProject<?, ?> owner, JobPropertyImpl property) {
        this.owner = owner;
        this.property = property;
    }

    private ISVNAuthenticationProvider getAuthProvider() {
        return this.getSubversion().getDescriptor().createAuthenticationProvider();
    }

    private SubversionReleaseSCM.ModuleLocation[] getLocations() {
        return this.getSubversion().getLocations();
    }

    public Collection<Revision> getRevisions() {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        int i = 1;
        int maxRevisions = Integer.parseInt(this.property.maxRevisions);
        for (Revision r : this.getRevisions(0L, -1L)) {
            revisions.add(r);
            if (++i <= maxRevisions) continue;
            break;
        }
        return revisions;
    }

    public Collection<Revision> getCompareRevisions() {
        return this.getRevisions(Long.parseLong(this.compare[0]), Long.parseLong(this.compare[1]));
    }

    public Collection<Revision> getRevisions(long start, long end) {
        DAVRepositoryFactory.setup();
        TreeMap revisions = new TreeMap(Collections.reverseOrder());
        for (SubversionReleaseSCM.ModuleLocation moduleLocation : this.getLocations()) {
            try {
                SVNURL svnUrl = moduleLocation.getSVNURL();
                SVNRepository repository = this.createSvnClientManager().createRepository(svnUrl, true);
                Collection logEntries = null;
                logEntries = repository.log(new String[]{""}, null, start, end, true, false);
                for (SVNLogEntry logEntry : logEntries) {
                    revisions.put(logEntry.getRevision(), new Revision(logEntry));
                    LOGGER.fine("---------------------------------------------");
                    LOGGER.fine("revision: " + logEntry.getRevision());
                    LOGGER.fine("author: " + logEntry.getAuthor());
                    LOGGER.fine("date: " + logEntry.getDate());
                    LOGGER.fine("log message: " + logEntry.getMessage());
                    LOGGER.fine("---------------------------------------------");
                }
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        for (SubversionReleaseSCM.ModuleLocation moduleLocation : this.owner.getBuilds().toArray(new Run[0])) {
            Revision revision;
            Long rev;
            try {
                EnvVars env = moduleLocation.getEnvironment(TaskListener.NULL);
                LOGGER.fine("---------ENV VARS FOR RUN:" + ((Run)moduleLocation).number);
                for (String key : env.keySet()) {
                    LOGGER.fine(key + " = " + (String)env.get(key));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((rev = Revision.getRevisionNumber((Run)moduleLocation)) == null || (revision = (Revision)revisions.get(rev)) == null) continue;
            revision.addBuild((Run)moduleLocation);
        }
        return revisions.values();
    }

    public String getUrlName() {
        return "releases";
    }

    public String getDisplayName() {
        return "Releases";
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public AbstractProject<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractProject<?, ?> owner) {
        this.owner = owner;
    }

    public JobPropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(JobPropertyImpl property) {
        this.property = property;
    }

    public SubversionReleaseSCM getSubversion() {
        return (SubversionReleaseSCM)this.owner.getScm();
    }

    public SVNClientManager createSvnClientManager() {
        this.getSubversion();
        return SubversionReleaseSCM.createSvnClientManager(this.getAuthProvider());
    }

    public void doCompare(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.setCompare(req.getParameterValues("compare"));
        req.getView((Object)this, "compare").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        req.bindParameters((Object)this);
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        values.add(new StringParameterValue("REVISION", this.revision));
        Hudson.getInstance().getQueue().schedule(this.owner, 0, new Action[]{new ParametersAction(values), new CauseAction((Cause)new Cause.UserCause())});
        rsp.forwardToPreviousPage(req);
    }

    public String[] getCompare() {
        return this.compare;
    }

    public void setCompare(String[] compare) {
        this.compare = compare;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }
}

