/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.SubversionReleaseSCM;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.xml.SVNXMLLogHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubversionReleaseChangeLogBuilder {
    private final Map<String, Long> previousRevisions;
    private final Map<String, Long> thisRevisions;
    private final BuildListener listener;
    private final SubversionReleaseSCM scm;
    private final AbstractBuild<?, ?> build;
    private static final LocatorImpl DUMMY_LOCATOR = new LocatorImpl();
    public static boolean debug = false;

    public SubversionReleaseChangeLogBuilder(AbstractBuild<?, ?> build, BuildListener listener, SubversionReleaseSCM scm) throws IOException {
        this.previousRevisions = SubversionReleaseSCM.parseRevisionFile((AbstractBuild)build.getPreviousBuild());
        this.thisRevisions = SubversionReleaseSCM.parseRevisionFile(build);
        this.listener = listener;
        this.scm = scm;
        this.build = build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Collection<SubversionReleaseSCM.External> externals, Result changeLog) throws IOException, InterruptedException {
        boolean changelogFileCreated = false;
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager();
        try {
            SVNLogClient svnlc = manager.getLogClient();
            TransformerHandler th = SubversionReleaseChangeLogBuilder.createTransformerHandler();
            th.setResult(changeLog);
            SVNXMLLogHandler logHandler = new SVNXMLLogHandler((ContentHandler)th);
            th.setDocumentLocator(DUMMY_LOCATOR);
            logHandler.startDocument();
            for (SubversionReleaseSCM.ModuleLocation l : this.scm.getLocations(this.build)) {
                changelogFileCreated |= this.buildModule(l.getURL(), svnlc, logHandler);
            }
            for (SubversionReleaseSCM.External ext : externals) {
                changelogFileCreated |= this.buildModule(this.getUrlForPath(this.build.getProject().getWorkspace().child(ext.path)), svnlc, logHandler);
            }
            if (changelogFileCreated) {
                logHandler.endDocument();
            }
            boolean bl = changelogFileCreated;
            return bl;
        }
        finally {
            manager.dispose();
        }
    }

    private String getUrlForPath(FilePath path) throws IOException, InterruptedException {
        return (String)path.act((FilePath.FileCallable)new GetUrlForPath(this.createAuthenticationProvider()));
    }

    private ISVNAuthenticationProvider createAuthenticationProvider() {
        return SubversionReleaseSCM.DescriptorImpl.DESCRIPTOR.createAuthenticationProvider();
    }

    private boolean buildModule(String url, SVNLogClient svnlc, SVNXMLLogHandler logHandler) throws IOException2 {
        PrintStream logger = this.listener.getLogger();
        Long prevRev = this.previousRevisions.get(url);
        if (prevRev == null) {
            logger.println("no revision recorded for " + url + " in the previous build");
            return false;
        }
        Long thisRev = this.thisRevisions.get(url);
        if (thisRev == null) {
            this.listener.error("No revision found for URL: " + url + " in " + SubversionReleaseSCM.getRevisionFile(this.build) + ". Revision file contains: " + this.thisRevisions.keySet());
            return true;
        }
        if (thisRev.equals(prevRev)) {
            logger.println("no change for " + url + " since the previous build");
            return false;
        }
        try {
            if (debug) {
                this.listener.getLogger().printf("Computing changelog of %1s from %2s to %3s\n", SVNURL.parseURIEncoded((String)url), prevRev + 1L, thisRev);
            }
            svnlc.doLog(SVNURL.parseURIEncoded((String)url), null, SVNRevision.UNDEFINED, SVNRevision.create((long)(prevRev + 1L)), SVNRevision.create((long)thisRev), false, true, 0L, (ISVNLogEntryHandler)(debug ? new DebugSVNLogHandler((ISVNLogEntryHandler)logHandler) : logHandler));
            if (debug) {
                this.listener.getLogger().println("done");
            }
        }
        catch (SVNException e) {
            throw new IOException2("revision check failed on " + url, (Throwable)e);
        }
        return true;
    }

    private static TransformerHandler createTransformerHandler() {
        try {
            return ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }

    static {
        DUMMY_LOCATOR.setLineNumber(-1);
        DUMMY_LOCATOR.setColumnNumber(-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetUrlForPath
    implements FilePath.FileCallable<String> {
        private final ISVNAuthenticationProvider authProvider;
        private static final long serialVersionUID = 1L;

        public GetUrlForPath(ISVNAuthenticationProvider authProvider) {
            this.authProvider = authProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String invoke(File p, VirtualChannel channel) throws IOException {
            SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(this.authProvider);
            try {
                SVNWCClient svnwc = manager.getWCClient();
                try {
                    SVNInfo info = svnwc.doInfo(p, SVNRevision.WORKING);
                    String string = info.getURL().toDecodedString();
                    return string;
                }
                catch (SVNException e) {
                    e.printStackTrace();
                    String string = null;
                    manager.dispose();
                    return string;
                }
            }
            finally {
                manager.dispose();
            }
        }
    }

    private class DebugSVNLogHandler
    implements ISVNLogEntryHandler {
        private final ISVNLogEntryHandler core;

        private DebugSVNLogHandler(ISVNLogEntryHandler core) {
            this.core = core;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            SubversionReleaseChangeLogBuilder.this.listener.getLogger().println("SVNLogEntry=" + logEntry);
            this.core.handleLogEntry(logEntry);
        }
    }
}

