/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_release_mgr;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.svn_release_mgr.ProjectReleaseAction;
import hudson.scm.SubversionReleaseSCM;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobPropertyImpl
extends JobProperty<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(JobPropertyImpl.class.getName());
    public final String maxRevisions;

    @DataBoundConstructor
    public JobPropertyImpl(String maxRevisions) {
        this.maxRevisions = maxRevisions;
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        Object action = super.getJobAction(job);
        if (SubversionReleaseSCM.class.equals(job.getScm().getClass())) {
            action = new ProjectReleaseAction(job, this);
        }
        return action;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        DescriptorImpl() {
            super(JobPropertyImpl.class);
            this.load();
        }

        public String getDisplayName() {
            return "Subversion Releases";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req.getParameter("releases.show") != null) {
                return new JobPropertyImpl(req.getParameter("maxRevisions"));
            }
            return null;
        }

        public void doCheckMaxRevisions(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            final String maxRevisions = req.getParameter("value");
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    try {
                        Integer.parseInt(Util.nullify((String)maxRevisions));
                        this.ok();
                    }
                    catch (NumberFormatException e) {
                        this.error("Enter an integer value only.");
                    }
                }
            }.process();
        }
    }
}

