/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SubversionReleaseChangeLogBuilder;
import hudson.scm.SubversionReleaseChangeLogParser;
import hudson.scm.SubversionReleaseSCM;
import hudson.scm.SubversionReleaseTagAction;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.subversion.Messages;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SubversionReleaseSCM
extends SCM
implements Serializable {
    private ModuleLocation[] locations = new ModuleLocation[0];
    private boolean useUpdate;
    private final SubversionRepositoryBrowser browser;
    @Deprecated
    private String modules;
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SubversionReleaseSCM.class.getName());
    private static final Logger LOGGER;

    public SubversionReleaseSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        ArrayList<ModuleLocation> modules = new ArrayList<ModuleLocation>();
        if (remoteLocations != null && localLocations != null) {
            int entries = Math.min(remoteLocations.length, localLocations.length);
            for (int i = 0; i < entries; ++i) {
                String remoteLoc = this.nullify(remoteLocations[i]);
                if (remoteLoc == null) continue;
                remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
                modules.add(new ModuleLocation(remoteLoc, this.nullify(localLocations[i])));
            }
        }
        this.locations = modules.toArray(new ModuleLocation[modules.size()]);
        this.useUpdate = useUpdate;
        this.browser = browser;
    }

    public SubversionReleaseSCM(String svnUrl) {
        this(new String[]{svnUrl}, new String[]{null}, true, null);
    }

    public String getModules() {
        return null;
    }

    public ModuleLocation[] getLocations() {
        return this.getLocations(null);
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(build);
        }
        return outLocations;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] locations = this.getLocations(build);
        try {
            Long rev;
            Map revisions = SubversionReleaseSCM.parseRevisionFile((AbstractBuild)build);
            if (locations.length == 1 && (rev = (Long)revisions.get(locations[0].remote)) != null) {
                env.put("SVN_REVISION", rev.toString());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new SubversionReleaseChangeLogBuilder(build, listener, this).run(externals, (Result)new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild build) throws IOException {
        HashMap<String, Long> revisions;
        block8: {
            revisions = new HashMap<String, Long>();
            File file = SubversionReleaseSCM.getRevisionFile((AbstractBuild)build);
            if (!file.exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block5: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.parseLong(line.substring(index + 1)));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) throws IOException {
        File file = SubversionReleaseSCM.getExternalsFile((AbstractProject)project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.access$000(), file).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List externals = this.checkout(build, workspace, (TaskListener)listener);
        if (externals == null) {
            return false;
        }
        PrintWriter w = new PrintWriter(new FileOutputStream(SubversionReleaseSCM.getRevisionFile((AbstractBuild)build)));
        try {
            Map revMap = (Map)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, (TaskListener)listener, externals));
            for (Map.Entry e : revMap.entrySet()) {
                w.println((String)e.getKey() + '/' + ((SvnInfo)e.getValue()).revision);
            }
            build.addAction((Action)new SubversionReleaseTagAction(build, revMap.values()));
        }
        finally {
            w.close();
        }
        new XmlFile(External.access$000(), SubversionReleaseSCM.getExternalsFile((AbstractProject)build.getProject())).write((Object)externals);
        return this.calcChangeLog(build, changelogFile, listener, externals);
    }

    private List<External> checkout(AbstractBuild build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            if (!this.repositoryLocationsExist(build, listener) && build.getProject().getLastSuccessfulBuild() != null) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getProject().getName() + ", project will be disabled.");
                build.getProject().makeDisabled(true);
                return null;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return null;
        }
        Boolean isUpdatable = this.useUpdate && (Boolean)workspace.act((FilePath.FileCallable)new IsUpdatableTask(build, this, listener)) != false;
        return (List)workspace.act((FilePath.FileCallable)new CheckOutTask(build, this, build.getTimestamp().getTime(), isUpdatable.booleanValue(), listener));
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam);
    }

    public static SVNClientManager createSvnClientManager() {
        return SubversionReleaseSCM.createSvnClientManager((ISVNAuthenticationProvider)DescriptorImpl.DESCRIPTOR.createAuthenticationProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(File workspace, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(workspace, SVNRevision.WORKING);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager((ISVNAuthenticationProvider)authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        try {
            if (!this.repositoryLocationsExist(lastBuild, listener)) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + project + ", project will be disabled.");
                project.makeDisabled(true);
                return false;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return false;
        }
        Map wsRev = SubversionReleaseSCM.parseRevisionFile((AbstractBuild)lastBuild);
        List externals = SubversionReleaseSCM.parseExternalsFile((AbstractProject)project);
        for (ModuleLocation loc : this.getLocations()) {
            if (wsRev.containsKey(loc.getURL())) continue;
            listener.getLogger().println("Workspace doesn't contain " + loc.getURL() + ". Need a new build");
            return true;
        }
        ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider();
        block5: for (Map.Entry localInfo : wsRev.entrySet()) {
            String url = (String)localInfo.getKey();
            for (External ext : externals) {
                if (!ext.url.equals(url) || !ext.isRevisionFixed()) continue;
                continue block5;
            }
            try {
                SvnInfo remoteInfo = new SvnInfo(SubversionReleaseSCM.parseSvnInfo((SVNURL)SVNURL.parseURIDecoded((String)url), (ISVNAuthenticationProvider)authProvider));
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_remoteRevisionAt((Object)url, (Object)remoteInfo.revision));
                if (remoteInfo.revision <= (Long)localInfo.getValue()) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_changedFrom(localInfo.getValue()));
                return true;
            }
            catch (SVNException e) {
                e.printStackTrace(listener.error("Failed to check repository revision for " + url));
                return false;
            }
        }
        Thread.sleep(60000L);
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionReleaseChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].local);
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].local);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsExist(AbstractBuild<?, ?> build, TaskListener listener) throws SVNException {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(build)) {
            if (this.getDescriptor().checkRepositoryPath(l.getSVNURL()) != SVNNodeKind.NONE) continue;
            out.println("Location '" + l.remote + "' does not exist");
            ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null) {
                out.println("Location could be expanded on build '" + build + "' parameters values:");
                for (ParameterValue paramValue : params) {
                    out.println("  " + paramValue);
                }
            }
            return false;
        }
        return true;
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        Level lv = level;
        com.trilead.ssh2.log.Logger.enabled = true;
        com.trilead.ssh2.log.Logger.logger = new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ SVNInfo access$200(File x0, ISVNAuthenticationProvider x1) throws SVNException {
        return SubversionReleaseSCM.parseSvnInfo((File)x0, (ISVNAuthenticationProvider)x1);
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }

    static /* synthetic */ String access$900(String x0) {
        return SubversionReleaseSCM.getLastPathComponent((String)x0);
    }

    static {
        new Initializer(null);
        LOGGER = Logger.getLogger(SubversionReleaseSCM.class.getName());
    }
}

