/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.thoughtworks.xstream.XStream;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.log.Logger;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SubversionReleaseChangeLogBuilder;
import hudson.scm.SubversionReleaseChangeLogParser;
import hudson.scm.SubversionReleaseTagAction;
import hudson.scm.SubversionReleaseUpdateEventHandler;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.scm.subversion.Messages;
import hudson.triggers.SCMTrigger;
import hudson.util.EditDistance;
import hudson.util.FormFieldValidator;
import hudson.util.IOException2;
import hudson.util.MultipartFormDataParser;
import hudson.util.Scrambler;
import hudson.util.StreamCopyThread;
import hudson.util.XStream2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionReleaseSCM
extends SCM
implements Serializable {
    private ModuleLocation[] locations = new ModuleLocation[0];
    private boolean useUpdate;
    private final SubversionRepositoryBrowser browser;
    @Deprecated
    private String modules;
    static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");
    private static final long serialVersionUID = 1L;
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(SubversionReleaseSCM.class.getName());
    private static final java.util.logging.Logger LOGGER;

    public SubversionReleaseSCM(String[] remoteLocations, String[] localLocations, boolean useUpdate, SubversionRepositoryBrowser browser) {
        ArrayList<ModuleLocation> modules = new ArrayList<ModuleLocation>();
        if (remoteLocations != null && localLocations != null) {
            int entries = Math.min(remoteLocations.length, localLocations.length);
            for (int i = 0; i < entries; ++i) {
                String remoteLoc = this.nullify(remoteLocations[i]);
                if (remoteLoc == null) continue;
                remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
                modules.add(new ModuleLocation(remoteLoc, this.nullify(localLocations[i])));
            }
        }
        this.locations = modules.toArray(new ModuleLocation[modules.size()]);
        this.useUpdate = useUpdate;
        this.browser = browser;
    }

    public SubversionReleaseSCM(String svnUrl) {
        this(new String[]{svnUrl}, new String[]{null}, true, null);
    }

    public String getModules() {
        return null;
    }

    public ModuleLocation[] getLocations() {
        return this.getLocations(null);
    }

    public ModuleLocation[] getLocations(AbstractBuild<?, ?> build) {
        if (this.modules != null) {
            ArrayList<ModuleLocation> oldLocations = new ArrayList<ModuleLocation>();
            StringTokenizer tokens = new StringTokenizer(this.modules);
            while (tokens.hasMoreTokens()) {
                String remoteLoc = Util.removeTrailingSlash((String)tokens.nextToken());
                oldLocations.add(new ModuleLocation(remoteLoc, null));
            }
            this.locations = oldLocations.toArray(new ModuleLocation[oldLocations.size()]);
            this.modules = null;
        }
        if (build == null) {
            return this.locations;
        }
        ModuleLocation[] outLocations = new ModuleLocation[this.locations.length];
        for (int i = 0; i < outLocations.length; ++i) {
            outLocations[i] = this.locations[i].getExpandedLocation(build);
        }
        return outLocations;
    }

    public boolean isUseUpdate() {
        return this.useUpdate;
    }

    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        ModuleLocation[] locations = this.getLocations(build);
        try {
            Long rev;
            Map<String, Long> revisions = SubversionReleaseSCM.parseRevisionFile(build);
            if (locations.length == 1 && (rev = revisions.get(locations[0].remote)) != null) {
                env.put("SVN_REVISION", rev.toString());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calcChangeLog(AbstractBuild<?, ?> build, File changelogFile, BuildListener listener, List<External> externals) throws IOException, InterruptedException {
        boolean created;
        if (build.getPreviousBuild() == null) {
            return this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(changelogFile));
        try {
            created = new SubversionReleaseChangeLogBuilder(build, listener, this).run(externals, new StreamResult(os));
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(changelogFile, listener, "log");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Long> parseRevisionFile(AbstractBuild build) throws IOException {
        HashMap<String, Long> revisions;
        block8: {
            revisions = new HashMap<String, Long>();
            File file = SubversionReleaseSCM.getRevisionFile(build);
            if (!file.exists()) {
                return revisions;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            block5: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    int index = line.lastIndexOf(47);
                    if (index < 0) continue;
                    try {
                        revisions.put(line.substring(0, index), Long.parseLong(line.substring(index + 1)));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                br.close();
            }
        }
        return revisions;
    }

    static List<External> parseExternalsFile(AbstractProject project) throws IOException {
        File file = SubversionReleaseSCM.getExternalsFile(project);
        if (file.exists()) {
            try {
                return (List)new XmlFile(External.XSTREAM, file).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List<External> externals = this.checkout(build, workspace, (TaskListener)listener);
        if (externals == null) {
            return false;
        }
        PrintWriter w = new PrintWriter(new FileOutputStream(SubversionReleaseSCM.getRevisionFile(build)));
        try {
            Map revMap = (Map)workspace.act((FilePath.FileCallable)new BuildRevisionMapTask(build, this, (TaskListener)listener, externals));
            for (Map.Entry e : revMap.entrySet()) {
                w.println((String)e.getKey() + '/' + ((SvnInfo)e.getValue()).revision);
            }
            build.addAction((Action)new SubversionReleaseTagAction(build, revMap.values()));
        }
        finally {
            w.close();
        }
        new XmlFile(External.XSTREAM, SubversionReleaseSCM.getExternalsFile(build.getProject())).write(externals);
        return this.calcChangeLog(build, changelogFile, listener, externals);
    }

    private List<External> checkout(AbstractBuild build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            if (!this.repositoryLocationsExist(build, listener) && build.getProject().getLastSuccessfulBuild() != null) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + build.getProject().getName() + ", project will be disabled.");
                build.getProject().makeDisabled(true);
                return null;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return null;
        }
        Boolean isUpdatable = this.useUpdate && (Boolean)workspace.act((FilePath.FileCallable)new IsUpdatableTask(build, this, listener)) != false;
        return (List)workspace.act((FilePath.FileCallable)new CheckOutTask(build, this, build.getTimestamp().getTime(), isUpdatable, listener));
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam);
    }

    public static SVNClientManager createSvnClientManager() {
        return SubversionReleaseSCM.createSvnClientManager(DescriptorImpl.DESCRIPTOR.createAuthenticationProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(File workspace, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(workspace, SVNRevision.WORKING);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNInfo parseSvnInfo(SVNURL remoteUrl, ISVNAuthenticationProvider authProvider) throws SVNException {
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(authProvider);
        try {
            SVNWCClient svnWc = manager.getWCClient();
            SVNInfo sVNInfo = svnWc.doInfo(remoteUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return sVNInfo;
        }
        finally {
            manager.dispose();
        }
    }

    public static File getRevisionFile(AbstractBuild build) {
        return new File(build.getRootDir(), "revision.txt");
    }

    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), "svnexternals.txt");
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        try {
            if (!this.repositoryLocationsExist(lastBuild, listener)) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + project + ", project will be disabled.");
                project.makeDisabled(true);
                return false;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return false;
        }
        Map<String, Long> wsRev = SubversionReleaseSCM.parseRevisionFile(lastBuild);
        List<External> externals = SubversionReleaseSCM.parseExternalsFile(project);
        for (ModuleLocation loc : this.getLocations()) {
            if (wsRev.containsKey(loc.getURL())) continue;
            listener.getLogger().println("Workspace doesn't contain " + loc.getURL() + ". Need a new build");
            return true;
        }
        ISVNAuthenticationProvider authProvider = this.getDescriptor().createAuthenticationProvider();
        block5: for (Map.Entry<String, Long> localInfo : wsRev.entrySet()) {
            String url = localInfo.getKey();
            for (External ext : externals) {
                if (!ext.url.equals(url) || !ext.isRevisionFixed()) continue;
                continue block5;
            }
            try {
                SvnInfo remoteInfo = new SvnInfo(SubversionReleaseSCM.parseSvnInfo(SVNURL.parseURIDecoded((String)url), authProvider));
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_remoteRevisionAt((Object)url, (Object)remoteInfo.revision));
                if (remoteInfo.revision <= localInfo.getValue()) continue;
                listener.getLogger().println(Messages.SubversionSCM_pollChanges_changedFrom((Object)localInfo.getValue()));
                return true;
            }
            catch (SVNException e) {
                e.printStackTrace(listener.error("Failed to check repository revision for " + url));
                return false;
            }
        }
        Thread.sleep(60000L);
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionReleaseChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.getLocations().length > 0) {
            return workspace.child(this.getLocations()[0].local);
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation[] moduleLocations = this.getLocations();
        if (moduleLocations.length > 0) {
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i].local);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public boolean repositoryLocationsExist(AbstractBuild<?, ?> build, TaskListener listener) throws SVNException {
        PrintStream out = listener.getLogger();
        for (ModuleLocation l : this.getLocations(build)) {
            if (this.getDescriptor().checkRepositoryPath(l.getSVNURL()) != SVNNodeKind.NONE) continue;
            out.println("Location '" + l.remote + "' does not exist");
            ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null) {
                out.println("Location could be expanded on build '" + build + "' parameters values:");
                for (ParameterValue paramValue : params) {
                    out.println("  " + paramValue);
                }
            }
            return false;
        }
        return true;
    }

    public static void enableSshDebug(Level level) {
        if (level == null) {
            level = Level.FINEST;
        }
        final Level lv = level;
        Logger.enabled = true;
        Logger.logger = new DebugLogger(){
            private final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SCPClient.class.getPackage().getName());

            public void log(int level, String className, String message) {
                this.LOGGER.log(lv, className + ' ' + message);
            }
        };
    }

    static {
        new Initializer();
        LOGGER = java.util.logging.Logger.getLogger(SubversionReleaseSCM.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ModuleLocation
    implements Serializable {
        public final String remote;
        public final String local;
        private static final long serialVersionUID = 1L;

        public ModuleLocation(String remote, String local) {
            if (local == null) {
                local = SubversionReleaseSCM.getLastPathComponent(remote);
            }
            this.remote = remote.trim();
            this.local = local.trim();
        }

        public String getURL() {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    Long.parseLong(n);
                    return this.remote.substring(0, idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.remote;
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIEncoded((String)this.getURL());
        }

        public SVNRevision getRevision(SVNRevision defaultValue) {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    return SVNRevision.create((long)Long.parseLong(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        private String getExpandedRemote(AbstractBuild<?, ?> build) {
            String outRemote = this.remote;
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outRemote = parameters.substitute(build, this.remote);
            }
            return outRemote;
        }

        public ModuleLocation getExpandedLocation(AbstractBuild<?, ?> build) {
            return new ModuleLocation(this.getExpandedRemote(build), this.local);
        }

        public String toString() {
            return this.remote;
        }
    }

    private static final class Initializer {
        private Initializer() {
        }

        static {
            if (Boolean.getBoolean("hudson.spool-svn")) {
                DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, true, null));
            } else {
                DAVRepositoryFactory.setup();
            }
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
            if (System.getProperty("svnkit.symlinks") == null) {
                System.setProperty("svnkit.symlinks", "false");
            }
            if (System.getProperty("svnkit.ssh2.persistent") == null) {
                System.setProperty("svnkit.ssh2.persistent", "false");
            }
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SubversionWorkspaceSelector());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<SubversionReleaseSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private final Map<String, Credential> credentials = new Hashtable<String, Credential>();
        private final transient RemotableSVNAuthenticationProviderImpl remotableProvider = new RemotableSVNAuthenticationProviderImpl();

        private DescriptorImpl() {
            super(SubversionReleaseSCM.class, SubversionRepositoryBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public String getDisplayName() {
            return "Subversion Release";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new SubversionReleaseSCM(req.getParameterValues("svn-r.location_remote"), req.getParameterValues("svn-r.location_local"), false, (SubversionRepositoryBrowser)RepositoryBrowsers.createInstance(SubversionRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser"));
        }

        public ISVNAuthenticationProvider createAuthenticationProvider() {
            return new SVNAuthenticationProviderImpl(this.remotableProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doPostCredential(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            File keyFile;
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
            String url = parser.get("url");
            String kind = parser.get("kind");
            int idx = Arrays.asList("", "password", "publickey", "certificate").indexOf(kind);
            final String username = parser.get("username" + idx);
            final String password = parser.get("password" + idx);
            FileItem item = null;
            if (idx <= 1) {
                keyFile = null;
            } else {
                item = parser.getFileItem(kind.equals("publickey") ? "privateKey" : "certificate");
                keyFile = File.createTempFile("hudson", "key");
                if (item != null) {
                    try {
                        item.write(keyFile);
                    }
                    catch (Exception e) {
                        throw new IOException2((Throwable)e);
                    }
                    if (PuTTYKey.isPuTTYKeyFile((File)keyFile)) {
                        LOGGER.info("Converting " + keyFile + " from PuTTY format to OpenSSH format");
                        new PuTTYKey(keyFile, null).toOpenSSH(keyFile);
                    }
                }
            }
            StringWriter log = new StringWriter();
            final PrintWriter logWriter = new PrintWriter(log);
            final boolean[] authenticationAttemped = new boolean[1];
            final boolean[] authenticationAcknowled = new boolean[1];
            SVNRepository repository = null;
            try {
                repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
                repository.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), true, username, password, keyFile, password){
                    Credential cred;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.cred = null;
                    }

                    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
                        authenticationAttemped[0] = true;
                        if (kind.equals("svn.username")) {
                            return new SVNUserNameAuthentication(username, false);
                        }
                        if (kind.equals("svn.simple")) {
                            logWriter.println("Passing user name " + username + " and password you entered");
                            this.cred = new PasswordCredential(username, password);
                        }
                        if (kind.equals("svn.ssh")) {
                            if (keyFile == null) {
                                logWriter.println("Passing user name " + username + " and password you entered to SSH");
                                this.cred = new PasswordCredential(username, password);
                            } else {
                                logWriter.println("Attempting a public key authentication with username " + username);
                                this.cred = new SshPublicKeyCredential(username, password, keyFile);
                            }
                        }
                        if (kind.equals("svn.ssl")) {
                            logWriter.println("Attempting an SSL client certificate authentcation");
                            this.cred = new SslClientCertificateCredential(keyFile, password);
                        }
                        if (this.cred == null) {
                            logWriter.println("Unknown authentication method: " + kind);
                            return null;
                        }
                        return this.cred.createSVNAuthentication(kind);
                    }

                    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
                        SVNErrorManager.authenticationFailed((String)("Authentication failed for " + url), null);
                        return null;
                    }

                    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
                        authenticationAcknowled[0] = true;
                        if (accepted) {
                            assert (this.cred != null);
                            DescriptorImpl.this.credentials.put(realm, this.cred);
                            DescriptorImpl.this.save();
                        } else {
                            logWriter.println("Failed to authenticate: " + errorMessage);
                            if (errorMessage.getCause() != null) {
                                errorMessage.getCause().printStackTrace(logWriter);
                            }
                        }
                        super.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
                    }
                });
                repository.testConnection();
                if (!authenticationAttemped[0]) {
                    logWriter.println("No authentication was attemped.");
                    throw new SVNCancelException();
                }
                if (!authenticationAcknowled[0]) {
                    logWriter.println("Authentication was not acknowledged.");
                    throw new SVNCancelException();
                }
                rsp.sendRedirect("credentialOK");
            }
            catch (SVNException e) {
                logWriter.println("FAILED: " + e.getErrorMessage());
                req.setAttribute("message", (Object)log.toString());
                req.setAttribute("pre", (Object)true);
                req.setAttribute("exception", (Object)e);
                rsp.forward((Object)Hudson.getInstance(), "error", req);
            }
            finally {
                if (keyFile != null) {
                    keyFile.delete();
                }
                if (item != null) {
                    item.delete();
                }
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        public void doSvnRemoteLocationCheck(final StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void check() throws IOException, ServletException {
                    block14: {
                        String url = Util.nullify((String)this.request.getParameter("value"));
                        if (url == null) {
                            this.ok();
                            return;
                        }
                        if (!URL_PATTERN.matcher(url = url.trim()).matches()) {
                            this.errorWithMarkup("Invalid URL syntax. See <a href=\"http://svnbook.red-bean.com/en/1.2/svn-book.html#svn.basic.in-action.wc.tbl-1\">this</a> for information about valid URLs.");
                            return;
                        }
                        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                            this.ok();
                        } else {
                            try {
                                SVNURL repoURL = SVNURL.parseURIDecoded((String)url);
                                if (DescriptorImpl.this.checkRepositoryPath(repoURL) == SVNNodeKind.NONE) {
                                    SVNRepository repository = null;
                                    try {
                                        String repoPath;
                                        repository = DescriptorImpl.this.getRepository(repoURL);
                                        long rev = repository.getLatestRevision();
                                        String p = repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                                        while (p.length() > 0) {
                                            if (repository.checkPath(p = SVNPathUtil.removeTail((String)p), rev) != SVNNodeKind.DIR) continue;
                                            ArrayList entries = new ArrayList();
                                            repository.getDir(p, rev, false, entries);
                                            ArrayList<String> paths = new ArrayList<String>();
                                            for (SVNDirEntry e : entries) {
                                                if (e.getKind() != SVNNodeKind.DIR) continue;
                                                paths.add(e.getName());
                                            }
                                            String head = SVNPathUtil.head((String)repoPath.substring(p.length() + 1));
                                            String candidate = EditDistance.findNearest((String)head, paths);
                                            this.error("'%1$s/%2$s' doesn't exist in the repository. Maybe you meant '%1$s/%3$s'?", new Object[]{p, head, candidate});
                                            return;
                                        }
                                        this.error(repoPath + " doesn't exist in the repository");
                                        break block14;
                                    }
                                    finally {
                                        if (repository != null) {
                                            repository.closeSession();
                                        }
                                    }
                                }
                                this.ok();
                            }
                            catch (SVNException e) {
                                String message = "";
                                message = message + "Unable to access " + Util.escape((String)url) + " : " + Util.escape((String)e.getErrorMessage().getFullMessage());
                                message = message + " <a href='#' id=svnerrorlink onclick='javascript:document.getElementById(\"svnerror\").style.display=\"block\";document.getElementById(\"svnerrorlink\").style.display=\"none\";return false;'>(show details)</a>";
                                message = message + "<pre id=svnerror style='display:none'>" + Functions.printThrowable((Throwable)e) + "</pre>";
                                message = message + " (Maybe you need to <a target='_new' href='" + req.getContextPath() + "/scm/SubversionReleaseSCM/enterCredential?" + url + "'>enter credential</a>?)";
                                message = message + "<br>";
                                logger.log(Level.INFO, "Failed to access subversion repository " + url, e);
                                this.errorWithMarkup(message);
                            }
                        }
                    }
                }
            }.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SVNNodeKind checkRepositoryPath(SVNURL repoURL) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(repoURL);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        protected SVNRepository getRepository(SVNURL repoURL) throws SVNException {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL);
            ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
            sam.setAuthenticationProvider(this.createAuthenticationProvider());
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(false).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        public void doSvnLocalLocationCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.nullify((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.ok();
                        return;
                    }
                    if ((v = v.trim()).startsWith("/") || v.startsWith("\\") || v.startsWith("..") || v.matches("^[A-Za-z]:")) {
                        this.error("absolute path is not allowed");
                    }
                    this.ok();
                }
            }.process();
        }

        static {
            new Initializer();
        }

        private static final class SVNAuthenticationProviderImpl
        implements ISVNAuthenticationProvider,
        Serializable {
            private final RemotableSVNAuthenticationProvider source;
            private static final long serialVersionUID = 1L;

            public SVNAuthenticationProviderImpl(RemotableSVNAuthenticationProvider source) {
                this.source = source;
            }

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                Credential cred = this.source.getCredential(realm);
                LOGGER.fine(String.format("requestClientAuthentication(%s,%s,%s)=>%s", kind, url, realm, cred));
                try {
                    SVNAuthentication auth = null;
                    if (cred != null) {
                        auth = cred.createSVNAuthentication(kind);
                    }
                    if (auth == null && "svn.username".equals(kind)) {
                        return new SVNUserNameAuthentication("", false);
                    }
                    return auth;
                }
                catch (SVNException e) {
                    logger.log(Level.SEVERE, "Failed to authorize", e);
                    throw new RuntimeException("Failed to authorize", e);
                }
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 1;
            }
        }

        private final class RemotableSVNAuthenticationProviderImpl
        implements RemotableSVNAuthenticationProvider,
        Serializable {
            private RemotableSVNAuthenticationProviderImpl() {
            }

            public Credential getCredential(String realm) {
                LOGGER.fine(String.format("getCredential(%s)=>%s", realm, DescriptorImpl.this.credentials.get(realm)));
                return (Credential)DescriptorImpl.this.credentials.get(realm);
            }

            private Object writeReplace() {
                return Channel.current().export(RemotableSVNAuthenticationProvider.class, (Object)this);
            }
        }

        private static interface RemotableSVNAuthenticationProvider {
            public Credential getCredential(String var1);
        }

        private static final class SslClientCertificateCredential
        extends Credential {
            private final String password;

            public SslClientCertificateCredential(File certificate, String password) {
                this.password = Scrambler.scramble((String)password);
            }

            SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssl")) {
                    return new SVNSSLAuthentication((byte[])null, Scrambler.descramble((String)this.password), false);
                }
                return null;
            }
        }

        private static final class SshPublicKeyCredential
        extends Credential {
            private final String userName;
            private final String passphrase;
            private final String id;

            public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
                this.userName = userName;
                this.passphrase = Scrambler.scramble((String)passphrase);
                Random r = new Random();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    buf.append(Integer.toHexString(r.nextInt(16)));
                }
                this.id = buf.toString();
                try {
                    FileUtils.copyFile((File)keyFile, (File)this.getKeyFile());
                }
                catch (IOException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to save private key"), (Throwable)e);
                }
            }

            private File getKeyFile() {
                File dir = new File(Hudson.getInstance().getRootDir(), "subversion-credentials");
                if (dir.mkdirs()) {
                    try {
                        Chmod chmod = new Chmod();
                        chmod.setProject(new Project());
                        chmod.setFile(dir);
                        chmod.setPerm("600");
                        chmod.execute();
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Failed to set directory permission of " + dir, e);
                    }
                }
                return new File(dir, this.id);
            }

            SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
                if (kind.equals("svn.ssh")) {
                    try {
                        Channel channel = Channel.current();
                        String privateKey = channel != null ? (String)channel.call((Callable)new Callable<String, IOException>(){

                            public String call() throws IOException {
                                return FileUtils.readFileToString((File)SshPublicKeyCredential.this.getKeyFile(), (String)"iso-8859-1");
                            }
                        }) : FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1");
                        return new SVNSSHAuthentication(this.userName, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                }
                return null;
            }
        }

        private static final class PasswordCredential
        extends Credential {
            private final String userName;
            private final String password;

            public PasswordCredential(String userName, String password) {
                this.userName = userName;
                this.password = Scrambler.scramble((String)password);
            }

            SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, Scrambler.descramble((String)this.password), -1, false);
                }
                return new SVNPasswordAuthentication(this.userName, Scrambler.descramble((String)this.password), false);
            }
        }

        private static abstract class Credential
        implements Serializable {
            private Credential() {
            }

            abstract SVNAuthentication createSVNAuthentication(String var1) throws SVNException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsUpdatableTask
    implements FilePath.FileCallable<Boolean> {
        private final TaskListener listener;
        private final ISVNAuthenticationProvider authProvider;
        private final ModuleLocation[] locations;
        private static final long serialVersionUID = 1L;

        IsUpdatableTask(AbstractBuild<?, ?> build, SubversionReleaseSCM parent, TaskListener listener) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider();
            this.listener = listener;
            this.locations = parent.getLocations(build);
        }

        public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
            for (ModuleLocation l : this.locations) {
                String moduleName = l.local;
                File module = new File(ws, moduleName).getCanonicalFile();
                if (!module.exists()) {
                    this.listener.getLogger().println("Checking out a fresh workspace because " + module + " doesn't exist");
                    return false;
                }
                try {
                    SVNInfo svnkitInfo = SubversionReleaseSCM.parseSvnInfo(module, this.authProvider);
                    SvnInfo svnInfo = new SvnInfo(svnkitInfo);
                    String url = l.getURL();
                    if (svnInfo.url.equals(url)) continue;
                    this.listener.getLogger().println("Checking out a fresh workspace because the workspace is not " + url);
                    return false;
                }
                catch (SVNException e) {
                    this.listener.getLogger().println("Checking out a fresh workspace because Hudson failed to detect the current workspace " + module);
                    e.printStackTrace(this.listener.error(e.getMessage()));
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildRevisionMapTask
    implements FilePath.FileCallable<Map<String, SvnInfo>> {
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener listener;
        private final List<External> externals;
        private final ModuleLocation[] locations;
        private static final long serialVersionUID = 1L;

        public BuildRevisionMapTask(AbstractBuild<?, ?> build, SubversionReleaseSCM parent, TaskListener listener, List<External> externals) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider();
            this.listener = listener;
            this.externals = externals;
            this.locations = parent.getLocations(build);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, SvnInfo> invoke(File ws, VirtualChannel channel) throws IOException {
            HashMap<String, SvnInfo> revisions = new HashMap<String, SvnInfo>();
            SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(this.authProvider);
            try {
                SVNWCClient svnWc = manager.getWCClient();
                for (ModuleLocation module : this.locations) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, module.local), SVNRevision.WORKING));
                        revisions.put(info.url, info);
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for " + module.remote));
                    }
                }
                for (External ext : this.externals) {
                    try {
                        SvnInfo info = new SvnInfo(svnWc.doInfo(new File(ws, ext.path), SVNRevision.WORKING));
                        revisions.put(info.url, info);
                    }
                    catch (SVNException e) {
                        e.printStackTrace(this.listener.error("Failed to parse svn info for external " + ext.url + " at " + ext.path));
                    }
                }
                HashMap<String, SvnInfo> hashMap = revisions;
                return hashMap;
            }
            finally {
                manager.dispose();
            }
        }
    }

    static final class External
    implements Serializable {
        final String path;
        final String url;
        final long revision;
        private static final long serialVersionUID = 1L;
        private static final XStream XSTREAM = new XStream2();

        External(String modulePath, SVNExternal ext) {
            this.path = modulePath + '/' + ext.getPath();
            this.url = ext.getResolvedURL().toDecodedString();
            this.revision = ext.getRevision().getNumber();
        }

        boolean isRevisionFixed() {
            return this.revision != -1L;
        }

        static {
            XSTREAM.alias("external", External.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SvnInfo
    implements Serializable,
    Comparable<SvnInfo> {
        public final String url;
        public final long revision;
        private static final long serialVersionUID = 1L;

        public SvnInfo(String url, long revision) {
            this.url = url;
            this.revision = revision;
        }

        public SvnInfo(SVNInfo info) {
            this(info.getURL().toDecodedString(), info.getCommittedRevision().getNumber());
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIDecoded((String)this.url);
        }

        @Override
        public int compareTo(SvnInfo that) {
            int r = this.url.compareTo(that.url);
            if (r != 0) {
                return r;
            }
            if (this.revision < that.revision) {
                return -1;
            }
            if (this.revision > that.revision) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SvnInfo svnInfo = (SvnInfo)o;
            if (this.revision != svnInfo.revision) {
                return false;
            }
            return this.url.equals(svnInfo.url);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s (rev.%s)", this.url, this.revision);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckOutTask
    implements FilePath.FileCallable<List<External>> {
        private final ISVNAuthenticationProvider authProvider;
        private final Date timestamp;
        private boolean update;
        private final TaskListener listener;
        private final ModuleLocation[] locations;
        private String revision;
        private static final long serialVersionUID = 1L;

        public CheckOutTask(AbstractBuild<?, ?> build, SubversionReleaseSCM parent, Date timestamp, boolean update, TaskListener listener) {
            this.authProvider = parent.getDescriptor().createAuthenticationProvider();
            this.timestamp = timestamp;
            this.update = update;
            this.listener = listener;
            this.locations = parent.getLocations(build);
            this.revision = (String)build.getEnvVars().get("REVISION");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public List<External> invoke(File ws, VirtualChannel channel) throws IOException {
            SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(this.authProvider);
            try {
                SVNUpdateClient svnuc = manager.getUpdateClient();
                ArrayList<External> externals = new ArrayList<External>();
                SVNRevision revision = SVNRevision.create((Date)this.timestamp);
                try {
                    if (this.revision != null) {
                        revision = SVNRevision.create((long)Long.parseLong(this.revision));
                    }
                }
                catch (NumberFormatException e) {
                    this.listener.getLogger().println("Unable to parse revision number from value: " + this.revision + ", checking out HEAD revision.");
                }
                if (this.update) {
                    for (ModuleLocation l : this.locations) {
                        try {
                            this.listener.getLogger().println("Updating " + l.remote);
                            File local = new File(ws, l.local);
                            svnuc.setEventHandler((ISVNEventHandler)new SubversionReleaseUpdateEventHandler(this.listener.getLogger(), externals, local, l.local));
                            svnuc.doUpdate(local.getCanonicalFile(), l.getRevision(revision), true);
                        }
                        catch (SVNException e) {
                            block25: {
                                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                                    this.listener.getLogger().println("Workspace appear to be locked, so getting a fresh workspace");
                                    this.update = false;
                                    Object object = this.invoke(ws, channel);
                                    manager.dispose();
                                    return object;
                                }
                                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_OBSTRUCTED_UPDATE) break block25;
                                this.listener.getLogger().println("Updated failed due to local files. Getting a fresh workspace");
                                this.update = false;
                                Object object = this.invoke(ws, channel);
                                manager.dispose();
                                return object;
                            }
                            e.printStackTrace(this.listener.error("Failed to update " + l.remote));
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                                this.listener.getLogger().println("Polled jobs are " + ((SCMTrigger.DescriptorImpl)Hudson.getInstance().getDescriptorByType(SCMTrigger.DescriptorImpl.class)).getItemsBeingPolled());
                            }
                            List<External> list = null;
                            manager.dispose();
                            return list;
                        }
                    }
                } else {
                    Util.deleteContentsRecursive((File)ws);
                    PipedOutputStream pos = new PipedOutputStream();
                    StreamCopyThread sct = new StreamCopyThread("svn log copier", (InputStream)new PipedInputStream(pos), (OutputStream)this.listener.getLogger());
                    sct.start();
                    for (ModuleLocation l : this.locations) {
                        try {
                            this.listener.getLogger().println("Checking out " + l.remote);
                            File local = new File(ws, l.local);
                            svnuc.setEventHandler((ISVNEventHandler)new SubversionReleaseUpdateEventHandler(new PrintStream(pos), externals, local, l.local));
                            svnuc.doCheckout(l.getSVNURL(), local.getCanonicalFile(), SVNRevision.HEAD, l.getRevision(revision), true);
                        }
                        catch (SVNException e) {
                            e.printStackTrace(this.listener.error("Failed to check out " + l.remote));
                            List<External> list = null;
                            manager.dispose();
                            return list;
                        }
                    }
                    pos.close();
                    try {
                        sct.join();
                    }
                    catch (InterruptedException e) {
                        throw new IOException2("interrupted", (Throwable)e);
                    }
                }
                try {
                    for (ModuleLocation l : this.locations) {
                        SVNDirEntry dir = manager.createRepository(l.getSVNURL(), true).info("/", -1L);
                        if (dir == null || !dir.getDate().after(new Date())) continue;
                        this.listener.getLogger().println(Messages.SubversionSCM_ClockOutOfSync());
                    }
                }
                catch (SVNException e) {
                    LOGGER.log(Level.INFO, "Failed to estimate the remote time stamp", e);
                }
                ArrayList<External> arrayList = externals;
                return arrayList;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                manager.dispose();
            }
        }
    }
}

