/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_release_mgr;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.svn_release_mgr.ProjectReleaseAction;
import hudson.scm.SubversionReleaseSCM;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobPropertyImpl
extends JobProperty<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(JobPropertyImpl.class.getName());
    public final String maxRevisions;

    @DataBoundConstructor
    public JobPropertyImpl(String maxRevisions) {
        this.maxRevisions = maxRevisions;
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        Object action = super.getJobAction(job);
        if (SubversionReleaseSCM.class.equals(job.getScm().getClass())) {
            action = new ProjectReleaseAction(job, this);
        }
        return action;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(JobPropertyImpl.class);
            this.load();
        }

        public String getDisplayName() {
            return "Subversion Releases";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req.getParameter("releases.show") != null) {
                return new JobPropertyImpl(req.getParameter("maxRevisions"));
            }
            return null;
        }
    }
}

