/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.ChangeLogAnnotator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public abstract class ChangeLogSet<T extends Entry>
implements Iterable<T> {
    public final AbstractBuild<?, ?> build;

    protected ChangeLogSet(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public abstract boolean isEmptySet();

    @Exported
    public final Object[] getItems() {
        ArrayList<Entry> r = new ArrayList<Entry>();
        for (Entry t : this) {
            r.add(t);
        }
        return r.toArray();
    }

    public static ChangeLogSet<? extends Entry> createEmpty(AbstractBuild build) {
        return new CVSChangeLogSet(build, Collections.emptyList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean(defaultVisibility=999)
    public static abstract class Entry {
        private ChangeLogSet parent;

        public ChangeLogSet getParent() {
            return this.parent;
        }

        protected void setParent(ChangeLogSet parent) {
            this.parent = parent;
        }

        public abstract String getMsg();

        public abstract User getAuthor();

        public abstract Collection<String> getAffectedPaths();

        public String getMsgAnnotated() {
            MarkupText markup = new MarkupText(this.getMsgEscaped());
            for (ChangeLogAnnotator a : ChangeLogAnnotator.annotators) {
                a.annotate(this.parent.build, this, markup);
            }
            return markup.toString();
        }

        public String getMsgEscaped() {
            return Util.escape((String)this.getMsg());
        }
    }
}

