/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.ExportTable;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.ProxyException;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.UserResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserRequest<RSP, EXC extends Throwable>
extends Request<UserResponse<RSP, EXC>, EXC> {
    private final byte[] request;
    private final RemoteClassLoader.IClassLoader classLoaderProxy;
    private final String toString;
    private final transient ExportTable.ExportList exports;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRequest(Channel local, Callable<?, EXC> c) throws IOException {
        this.exports = local.startExportRecording();
        try {
            this.request = this.serialize(c, local);
        }
        finally {
            this.exports.stopRecording();
        }
        this.toString = c.toString();
        ClassLoader cl = UserRequest.getClassLoader(c);
        this.classLoaderProxy = RemoteClassLoader.export(cl, local);
    }

    static ClassLoader getClassLoader(Callable<?, ?> c) {
        if (c instanceof DelegatingCallable) {
            return ((DelegatingCallable)c).getClassLoader();
        }
        return c.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UserResponse<RSP, EXC> perform(Channel channel) throws EXC {
        try {
            ClassLoader cl = channel.importedClassLoaders.get(this.classLoaderProxy);
            Object r = null;
            Channel oldc = Channel.setCurrent(channel);
            try {
                Object o;
                try {
                    o = new ObjectInputStreamEx(new ByteArrayInputStream(this.request), cl).readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException("Failed to deserialize the Callable object. Perhaps you needed to implement DelegatingCallable?", e);
                }
                Callable callable = (Callable)o;
                if (channel.isRestricted && !(callable instanceof RemoteInvocationHandler.RPCRequest)) {
                    throw new SecurityException("Execution of " + callable.toString() + " is prohibited because the channel is restricted");
                }
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    r = callable.call();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            finally {
                Channel.setCurrent(oldc);
            }
            return new UserResponse(this.serialize(r, channel), false);
        }
        catch (Throwable e) {
            byte[] response;
            try {
                response = this._serialize(e, channel);
            }
            catch (NotSerializableException x) {
                response = this.serialize(new ProxyException(e), channel);
            }
            return new UserResponse(response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _serialize(Object o, Channel localChannel) throws IOException {
        Channel old = Channel.setCurrent(localChannel);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectOutputStream(baos).writeObject(o);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    private byte[] serialize(Object o, Channel localChannel) throws IOException {
        try {
            return this._serialize(o, localChannel);
        }
        catch (NotSerializableException e) {
            IOException x = new IOException("Unable to serialize " + o);
            x.initCause(e);
            throw x;
        }
    }

    public void releaseExports() {
        this.exports.release();
    }

    public String toString() {
        return "UserRequest:" + this.toString;
    }
}

