/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class Which {
    private static final Logger LOGGER = Logger.getLogger(Which.class.getName());

    public static URL jarURL(Class clazz) throws IOException {
        URL res;
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((res = cl.getResource(clazz.getName().replace('.', '/') + ".class")) == null) {
            throw new IllegalArgumentException("Unable to locate class file for " + clazz);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File jarFile(Class clazz) throws IOException {
        URLConnection con;
        String resURL;
        URL res = Which.jarURL(clazz);
        String originalURL = resURL = res.toExternalForm();
        if (resURL.startsWith("jar:file:") || resURL.startsWith("wsjar:file:")) {
            return Which.fromJarUrlToFile(resURL);
        }
        if (resURL.startsWith("code-source:/")) {
            resURL = resURL.substring("code-source:/".length(), resURL.lastIndexOf(33));
            return new File(Which.decode(new URL("file:/" + resURL).getPath()));
        }
        if (resURL.startsWith("file:")) {
            for (int n = clazz.getName().split("\\.").length; n > 0; --n) {
                int idx = Math.max(resURL.lastIndexOf(47), resURL.lastIndexOf(92));
                if (idx < 0) {
                    throw new IllegalArgumentException(originalURL + " - " + resURL);
                }
                resURL = resURL.substring(0, idx);
            }
            return new File(Which.decode(new URL(resURL).getPath()));
        }
        if (resURL.startsWith("vfszip:")) {
            InputStream is = res.openStream();
            try {
                Field f = is.getClass().getDeclaredField("delegate");
                f.setAccessible(true);
                Object delegate = f.get(is);
                f = delegate.getClass().getDeclaredField("this$0");
                f.setAccessible(true);
                ZipFile zipFile = (ZipFile)f.get(delegate);
                File file = new File(zipFile.getName());
                return file;
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
            }
            finally {
                is.close();
            }
        }
        if ((con = res.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jcon = (JarURLConnection)con;
            JarFile jarFile = jcon.getJarFile();
            String n = jarFile.getName();
            if (n.length() > 0) {
                return new File(n);
            }
            try {
                Field f = ZipFile.class.getDeclaredField("name");
                f.setAccessible(true);
                return new File((String)f.get(jarFile));
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.INFO, "Failed to obtain the local cache file name of " + clazz, e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.INFO, "Failed to obtain the local cache file name of " + clazz, e);
            }
        }
        throw new IllegalArgumentException(originalURL + " - " + resURL);
    }

    public static File jarFile(URL resource) throws IOException {
        return Which.fromJarUrlToFile(resource.toExternalForm());
    }

    private static File fromJarUrlToFile(String resURL) throws MalformedURLException {
        resURL = resURL.substring(resURL.indexOf(58) + 1, resURL.lastIndexOf(33));
        return new File(Which.decode(new URL(resURL).getPath()));
    }

    private static String decode(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                baos.write(Which.hexToInt(s.charAt(i + 1)) * 16 + Which.hexToInt(s.charAt(i + 2)));
                i += 2;
                continue;
            }
            baos.write(ch);
        }
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static int hexToInt(int ch) {
        return Character.getNumericValue(ch);
    }
}

