/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class ProxyOutputStream
extends OutputStream {
    private Channel channel;
    private int oid;
    private ByteArrayOutputStream tmp;
    private boolean closed;

    public ProxyOutputStream() {
    }

    public ProxyOutputStream(Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        if (oid == 0) {
            throw new IllegalArgumentException("oid=0");
        }
        this.channel = channel;
        this.oid = oid;
        if (this.tmp != null) {
            channel.send(new Chunk(oid, this.tmp.toByteArray()));
            this.tmp = null;
        }
        if (this.closed) {
            this.doClose();
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        if (off == 0 && len == b.length) {
            this.write(b);
        } else {
            byte[] buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
            this.write(buf);
        }
    }

    public synchronized void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        if (this.channel == null) {
            if (this.tmp == null) {
                this.tmp = new ByteArrayOutputStream();
            }
            this.tmp.write(b);
        } else {
            this.channel.send(new Chunk(this.oid, b));
        }
    }

    public void flush() throws IOException {
        if (this.channel != null) {
            this.channel.send(new Flush(this.oid));
        }
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.channel != null) {
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        this.channel.send(new EOF(this.oid));
        this.channel = null;
        this.oid = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.channel != null) {
            this.channel.send(new Unexport(this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public EOF(int oid) {
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            channel.unexport(this.oid);
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Pipe.EOF(" + this.oid + ")";
        }
    }

    private static class Unexport
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public Unexport(int oid) {
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            channel.unexport(this.oid);
        }

        public String toString() {
            return "Pipe.Unexport(" + this.oid + ")";
        }
    }

    private static final class Flush
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public Flush(int oid) {
            super(false);
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            try {
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Pipe.Flush(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int oid;
        private final byte[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int oid, byte[] buf) {
            super(false);
            this.oid = oid;
            this.buf = buf;
        }

        protected void execute(Channel channel) {
            OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            try {
                os.write(this.buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Pipe.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

