/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ProxyOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class RemoteOutputStream
extends OutputStream
implements Serializable {
    private transient OutputStream core;
    private static final long serialVersionUID = 1L;

    public RemoteOutputStream(OutputStream core) {
        if (core == null) {
            throw new IllegalArgumentException();
        }
        this.core = core;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int id = Channel.current().export(this.core, false);
        oos.writeInt(id);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = Channel.current();
        assert (channel != null);
        this.core = new ProxyOutputStream(channel, ois.readInt());
    }

    public void write(int b) throws IOException {
        this.core.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.core.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.core.write(b, off, len);
    }

    public void flush() throws IOException {
        this.core.flush();
    }

    public void close() throws IOException {
        this.core.close();
    }
}

