/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.RetryException;
import hudson.remoting.Launcher;
import hudson.remoting.jnlp.Main;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    protected final DatagramSocket socket;
    protected Candidate target;
    @Option(name="-name", usage="Name of the slave")
    public String name;
    @Option(name="-description", usage="Description to be put on the slave")
    public String description;
    @Option(name="-labels", usage="Whitespace-separated list of labels to be assigned for this slave. Multiple options are allowed.")
    public List<String> labels = new ArrayList<String>();
    @Option(name="-fsroot", usage="Directory where Hudson places files")
    public File remoteFsRoot = new File(".");
    @Option(name="-executors", usage="Number of executors")
    public int executors = Runtime.getRuntime().availableProcessors();
    @Option(name="-master", usage="Host name or IP address of the master. If this option is specified, auto-discovery will be skipped")
    public String master;
    @Option(name="-help", aliases={"--help"}, usage="Show the help screen")
    public boolean help;

    public static void main(String ... args) throws InterruptedException, IOException {
        Client client = new Client();
        CmdLineParser p = new CmdLineParser((Object)client);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.out.println(e.getMessage());
            p.printUsage((OutputStream)System.out);
            System.exit(-1);
        }
        if (client.help) {
            p.printUsage((OutputStream)System.out);
            System.exit(0);
        }
        client.run();
    }

    public Client() throws IOException {
        this.socket = new DatagramSocket();
        this.socket.setBroadcast(true);
        this.name = InetAddress.getLocalHost().getCanonicalHostName();
    }

    public void run() throws InterruptedException {
        System.out.println("Discovering Hudson master");
        while (true) {
            block11: {
                try {
                    ArrayList<Candidate> candidates = new ArrayList<Candidate>();
                    for (DatagramPacket recv : this.discover()) {
                        Document xml;
                        String responseXml = new String(recv.getData(), 0, recv.getLength());
                        try {
                            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(recv.getData(), 0, recv.getLength()));
                        }
                        catch (SAXException e) {
                            System.out.println("Invalid response XML from " + recv.getAddress() + ": " + responseXml);
                            continue;
                        }
                        String swarm = Client.getChildElementString(xml.getDocumentElement(), "swarm");
                        if (swarm == null) {
                            System.out.println(recv.getAddress() + " doesn't support swarm");
                            continue;
                        }
                        String url = Client.getChildElementString(xml.getDocumentElement(), "url");
                        if (url == null) {
                            System.out.println(recv.getAddress() + " doesn't have the configuration set yet. Please go to the sytem configuration page of this Hudson and submit it: " + responseXml);
                            continue;
                        }
                        candidates.add(new Candidate(url, swarm));
                    }
                    if (candidates.size() == 0) {
                        throw new RetryException("No nearby Hudson supports swarming");
                    }
                    System.out.println("Found " + candidates.size() + " eligible Hudson.");
                    this.target = (Candidate)candidates.get(new Random().nextInt(candidates.size()));
                    this.verifyThatUrlIsHudson();
                    this.createSwarmSlave();
                    this.connect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (RetryException e) {
                    System.out.println(e.getMessage());
                    if (e.getCause() == null) break block11;
                    e.getCause().printStackTrace();
                }
            }
            System.out.println("Retrying in 10 seconds");
            Thread.sleep(10000L);
        }
    }

    protected List<DatagramPacket> discover() throws IOException, InterruptedException, RetryException {
        this.sendBroadcast();
        ArrayList<DatagramPacket> responses = new ArrayList<DatagramPacket>();
        long limit = System.currentTimeMillis() + 5000L;
        try {
            while (true) {
                this.socket.setSoTimeout(Math.max(1, (int)(limit - System.currentTimeMillis())));
                DatagramPacket recv = new DatagramPacket(new byte[2048], 2048);
                this.socket.receive(recv);
                responses.add(recv);
            }
        }
        catch (SocketTimeoutException e) {
            if (responses.isEmpty()) {
                if (this.master != null) {
                    throw new RetryException("Failed to receive a reply from " + this.master);
                }
                throw new RetryException("Failed to receive a reply to broadcast.");
            }
            return responses;
        }
    }

    protected void sendBroadcast() throws IOException {
        DatagramPacket packet = new DatagramPacket(new byte[0], 0);
        packet.setAddress(InetAddress.getByName(this.master != null ? this.master : "255.255.255.255"));
        packet.setPort(Integer.getInteger("hudson.udp", 33848));
        this.socket.send(packet);
    }

    protected void connect() throws InterruptedException {
        try {
            Launcher launcher = new Launcher();
            launcher.slaveJnlpURL = new URL(this.target.url + "/computer/" + this.name + "/slave-agent.jnlp");
            List jnlpArgs = launcher.parseJnlpArguments();
            jnlpArgs.add("-noreconnect");
            Main.main((String[])jnlpArgs.toArray(new String[jnlpArgs.size()]));
        }
        catch (Exception e) {
            System.out.println("Failed to establish JNLP connection to " + this.target.url);
            Thread.sleep(10000L);
        }
    }

    protected void createSwarmSlave() throws IOException, InterruptedException, RetryException {
        StringBuilder labelStr = new StringBuilder();
        for (String l : this.labels) {
            if (labelStr.length() > 0) {
                labelStr.append(' ');
            }
            labelStr.append(l);
        }
        HttpURLConnection con = (HttpURLConnection)new URL(this.target.url + "/plugin/swarm/createSlave?name=" + this.name + "&executors=" + this.executors + this.param("remoteFsRoot", this.remoteFsRoot.getAbsolutePath()) + this.param("description", this.description) + this.param("labels", labelStr.toString()) + "&secret=" + this.target.secret).openConnection();
        if (con.getResponseCode() != 200) {
            Client.copy(con.getErrorStream(), System.out);
            throw new RetryException("Failed to create a slave on Hudson: " + con.getResponseCode() + " " + con.getResponseMessage());
        }
    }

    private String param(String name, String value) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        return "&" + name + "=" + URLEncoder.encode(value, "UTF-8");
    }

    protected void verifyThatUrlIsHudson() throws InterruptedException, RetryException {
        try {
            System.out.println("Connecting to " + this.target.url);
            HttpURLConnection con = (HttpURLConnection)new URL(this.target.url).openConnection();
            con.connect();
            String v = con.getHeaderField("X-Hudson");
            if (v == null) {
                throw new RetryException("This URL doesn't look like Hudson.");
            }
        }
        catch (IOException e) {
            throw new RetryException("Failed to connect to " + this.target.url, e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private static String getChildElementString(Element parent, String tagName) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getTagName().equals(tagName)) continue;
            StringBuilder buf = new StringBuilder();
            for (n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Text)) continue;
                buf.append(n.getTextContent());
            }
            return buf.toString();
        }
        return null;
    }

    class Candidate {
        final String url;
        final String secret;

        Candidate(String url, String secret) {
            this.url = url;
            this.secret = secret;
        }
    }
}

