/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

public class SwarmSlave
extends Slave
implements EphemeralNode {
    private static final JNLPLauncher SELF_CLEANUP_LAUNCHER = new JNLPLauncher(){

        public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
            try {
                Hudson.getInstance().removeNode((Node)computer.getNode());
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(e.getMessage()));
            }
        }
    };

    @DataBoundConstructor
    public SwarmSlave(String name, String nodeDescription, String remoteFS, String numExecutors, String label) throws IOException, Descriptor.FormException {
        super(name, nodeDescription, remoteFS, numExecutors, Node.Mode.NORMAL, label, (ComputerLauncher)SELF_CLEANUP_LAUNCHER, RetentionStrategy.NOOP, Collections.emptyList());
    }

    public Node asNode() {
        return this;
    }

    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Swarm Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

